<?php

namespace Daylight\Mollie\Http\Controllers;

use Daylight\Core\Modules\Payment\Events\WebhookReceived;
use Daylight\Mollie\Http\Requests\IncomingWebhookRequest;

class WebhookController
{
    public function __invoke(IncomingWebhookRequest $request)
    {
        $order = daylightModel('order')::query()
            ->wherePaymentGatewayId($request->get('id'))
            ->firstOrFail();

        WebhookReceived::dispatch($order);

        return [];
    }
}
