<?php

namespace Daylight\Mollie\PaymentMethods;

use Daylight\Core\Modules\Payment\PaymentMethod;
use Illuminate\Support\Facades\Vite;

class Ideal extends PaymentMethod
{
    public function getId(): string
    {
        return 'ideal';
    }

    public function getName(): string
    {
        return __('iDEAL');
    }

    public function getGatewayKey(): string
    {
        return 'ideal';
    }

    public function getIcon(): string
    {
        return Vite::asset('resources/images/payment/ideal.svg');
    }

    public function transactionFee(): float
    {
        return 0;
    }

    public function order(): int
    {
        return 0;
    }
}
