<?php

namespace Daylight\Mollie;

use Daylight\Core\Modules\Payment\Contracts\PaymentBuilder;
use Daylight\Core\Modules\Payment\Contracts\PaymentStatusBuilder;
use Daylight\Core\Modules\Payment\Contracts\ProvidesPaymentMethods;
use Daylight\Mollie\Http\Controllers\WebhookController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider;

class MollieServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        $this->app->singleton(ProvidesPaymentMethods::class, PaymentMethods::class);
        $this->app->singleton(PaymentBuilder::class, Builders\PaymentBuilder::class);
        $this->app->singleton(PaymentStatusBuilder::class, Builders\PaymentStatusBuilder::class);

        Route::macro('mollie', function () {
            Route::prefix('mollie')->group(function () {
                Route::post('/webhook', WebhookController::class)->name('mollie.webhook');
            });
        });
    }
}
