<?php

namespace Daylight\Mollie\PaymentMethods;

use Daylight\Core\Modules\Payment\PaymentMethod;
use Illuminate\Support\Facades\Vite;

class Bancontact extends PaymentMethod
{
    public function getId(): string
    {
        return 'bancontact';
    }

    public function getName(): string
    {
        return __('Bancontact');
    }

    public function getGatewayKey(): string
    {
        return 'bancontact';
    }

    public function getIcon(): string
    {
        return Vite::asset('resources/images/payment/bancontact.svg');
    }

    public function transactionFee(): float
    {
        return 0;
    }

    public function order(): int
    {
        return 0;
    }
}
