<?php

namespace Daylight\Mollie\PaymentMethods;

use Daylight\Core\Modules\Payment\PaymentMethod;
use Illuminate\Support\Facades\Vite;

class PayPal extends PaymentMethod
{
    public function getId(): string
    {
        return 'paypal';
    }

    public function getName(): string
    {
        return __('PayPal');
    }

    public function getGatewayKey(): string
    {
        return 'paypal';
    }

    public function getIcon(): string
    {
        return Vite::asset('resources/images/payment/paypal.svg');
    }

    public function transactionFee(): float
    {
        return 0;
    }

    public function order(): int
    {
        return 0;
    }
}
