<?php

namespace App\Daylight\Http\Requests\Content\Questions;

use Illuminate\Foundation\Http\FormRequest;

class StoreQuestionRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->user()->can('update:pages');
    }

    public function rules(): array
    {
        return [
            'locale' => ['required', 'string', 'max:10'],
            'question_category_id' => ['required', 'exists:question_categories,id'],
            'name' => ['required', 'string', 'max:255'],
            'content' => ['required', 'string'],
        ];
    }
}
