<?php

namespace App\Http\Controllers\Account;

use App\Http\Controllers\Controller;
use App\Http\Requests\Account\UpdateAccountRequest;
use Daylight\Core\Modules\Multilingualism\Entities\LocalizedRoute;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Redirect;
use Illuminate\View\View;

class AccountController extends Controller
{
    public function index(): View
    {
        $localizedRoute = LocalizedRoute::create()
            ->setRoute('account.index')
            ->staticRoute();

        return view('account.index', [
            'user' => auth()->user()->load('customer'),
            'localizedRoute' => $localizedRoute,
        ]);
    }

    public function update(UpdateAccountRequest $request): RedirectResponse
    {
        $request->user()->fill($request->safe()->toArray());

        if ($request->user()->isDirty('email')) {
            $request->user()->email_verified_at = null;
            $request->user()->sendEmailVerificationNotification();
        }

        $request->user()->save();

        return Redirect::translatedRoute('account.index')
            ->with('success', __('Your profile has been updated.'));
    }
}
