<?php

namespace App\Livewire\Cart;

use App\Livewire\Cart\Concerns\InteractsWithCart;
use Illuminate\View\View;
use Livewire\Attributes\On;
use Livewire\Component;

class Drawer extends Component
{
    use InteractsWithCart;

    public bool $showCartSummary = false;

    #[On('show-cart-summary')]
    public function showCartSummary(): void
    {
        $this->showCartSummary = true;
    }

    public function render(): View
    {
        return view('livewire.cart.drawer');
    }
}
