<?php

namespace App\Models;

use App\Models\Translations\TestimonialTranslation;
use Daylight\Core\Modules\Multilingualism\Contracts\HasTranslations;
use Daylight\Core\Modules\Multilingualism\Models\Concerns\InteractsWithTranslations;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Testimonial extends Model implements HasTranslations
{
    use InteractsWithTranslations;

    protected $guarded = [];

    public function translatedFields(): array
    {
        return ['title', 'content'];
    }

    public function translations(): HasMany
    {
        return $this->hasMany(TestimonialTranslation::class);
    }

    public function defaultTranslation(): HasOne
    {
        return $this
            ->hasOne(TestimonialTranslation::class)
            ->where('locale', config('app.fallback_locale'));
    }
}
