@section('head')
    <link rel="canonical" href="{{ $localizedRoute->getCanonical()  }}"/>

    @foreach($localizedRoute->getHrefLangLinks() as $locale => $link)
        <link rel="alternate" hreflang="{{ $locale }}" href="{{ $link }}">
    @endforeach
@endsection

<x-layouts.app :title="__('Edit address')" :localizedRoute="$localizedRoute">
    <x-breadcrumbs
        :pages="[
            __('Account') => translatedRoute('account.index'),
            __('Addresses') => translatedRoute('account.addresses.index'),
            __('Create address') => translatedRoute('account.addresses.create'),
        ]"
    />

    <main class="bg-white padding">
        <div class="container">
            <div class="row">
                @include('account.navigation')

                <div class="col-12 col-lg-9">
                    <x-panel :title="__('Create address')">
                        <x-slot:description>
                            <p>{{ __('Fill in the form below to create a new address.') }}</p>
                        </x-slot:description>

                        <x-session-messages />

                        <form action="{{ translatedRoute('account.addresses.store') }}" method="post">
                            @csrf

                            <input type="hidden" name="type" value="{{ request('type', 'billing') }}">

                            <x-input.group
                                for="name"
                                :label="__('Name')"
                                :error="$errors->first('name')"
                                :required="true"
                            >
                                <x-input.text
                                    id="name"
                                    name="name"
                                    :value="old('name')"
                                />
                            </x-input.group>

                            @if(request('type', 'billing') === \Daylight\Core\Models\Enums\AddressType::BILLING->value)
                                <div class="row">
                                    <div class="col-12 col-md-6">
                                        <x-input.group
                                            for="kvk_number"
                                            :label="__('KVK number')"
                                            :error="$errors->first('kvk_number')"
                                            :required="true"
                                        >
                                            <x-input.text
                                                id="kvk_number"
                                                name="kvk_number"
                                                type="text"
                                                :placeholder="__('12345678')"
                                                :value="old('kvk_number')"
                                            />
                                        </x-input.group>
                                    </div>

                                    <div class="col-12 col-md-6">
                                        <x-input.group
                                            for="vat_number"
                                            :label="__('VAT number')"
                                            :error="$errors->first('vat_number')"
                                            :required="true"
                                        >
                                            <x-input.text
                                                id="vat_number"
                                                name="vat_number"
                                                type="text"
                                                :placeholder="__('NL123456789B01')"
                                                :value="old('vat_number')"
                                            />
                                        </x-input.group>
                                    </div>
                                </div>
                            @endif

                            <x-input.group
                                for="address_line_1"
                                :label="__('Address line 1')"
                                :error="$errors->first('address_line_1')"
                                :required="true"
                            >
                                <x-input.text
                                    id="address_line_1"
                                    name="address_line_1"
                                    type="address_line_1"
                                    :placeholder="__('Main Street 12')"
                                    :value="old('address_line_1')"
                                />
                            </x-input.group>

                            <x-input.group
                                for="address_line_2"
                                :label="__('Address line 2')"
                                :error="$errors->first('address_line_2')"
                            >
                                <x-input.text
                                    id="address_line_2"
                                    name="address_line_2"
                                    type="address_line_2"
                                    :placeholder="__('Apartment 34')"
                                    :value="old('address_line_2')"
                                />
                            </x-input.group>

                            <div class="row">
                                <div class="col-12 col-md-6">
                                    <x-input.group
                                        for="postal_code"
                                        :label="__('Postal code')"
                                        :error="$errors->first('postal_code')"
                                        :required="true"
                                    >
                                        <x-input.text
                                            id="postal_code"
                                            name="postal_code"
                                            type="text"
                                            :placeholder="__('1234 AB')"
                                            :value="old('postal_code')"
                                        />
                                    </x-input.group>
                                </div>

                                <div class="col-12 col-md-6">
                                    <x-input.group
                                        for="city"
                                        :label="__('City')"
                                        :error="$errors->first('city')"
                                        :required="true"
                                    >
                                        <x-input.text
                                            id="city"
                                            name="city"
                                            type="text"
                                            :placeholder="__('Amsterdam')"
                                            :value="old('city')"
                                        />
                                    </x-input.group>
                                </div>
                            </div>

                            <x-input.group
                                for="country_id"
                                :label="__('Country')"
                                :error="$errors->first('country_id')"
                                :required="true"
                            >
                                <x-input.select
                                    id="country_id"
                                    name="country_id"
                                >
                                    @foreach($countries as $id => $country)
                                        <option value="{{ $id }}" @if($id == old('country', 26)) selected @endif>
                                            {{ $country }}
                                        </option>
                                    @endforeach
                                </x-input.select>
                            </x-input.group>

                            <div class="row align-items-center mt-4">
                                <div class="col-6">
                                    <label class="checkbox-group" for="default">
                                        <input
                                            type="checkbox"
                                            name="default"
                                            id="default"
                                            value="1"
                                            @if(old('default')) checked @endif
                                        >
                                        <span>
                                            {{ __('Default address') }}
                                        </span>
                                    </label>
                                </div>

                                <div class="col-6 text-right">
                                    <button class="button button--primary" type="submit">
                                        {{ __('Save') }}
                                    </button>
                                </div>
                            </div>
                        </form>

                    </x-panel>
                </div>
            </div>
        </div>
    </main>
</x-layouts.app>
