@section('head')
    <link rel="canonical" href="{{ $localizedRoute->getCanonical()  }}"/>

    @foreach($localizedRoute->getHrefLangLinks() as $locale => $link)
        <link rel="alternate" hreflang="{{ $locale }}" href="{{ $link }}">
    @endforeach
@endsection

<x-layouts.app :title="__('Reset password')" :localizedRoute="$localizedRoute">
    <x-breadcrumbs :pages="[ __('Reset password') => translatedRoute('password.reset', $request->route('token')) ]" />

    <main class="bg-white padding">
        <div class="container">
            <div class="row">
                <div class="col-12 col-lg-6">
                    <x-panel :title="__('Reset password')">
                        <x-slot:description>
                            <p>{{ __('Fill in the fields below to reset your password.') }}
                        </x-slot:description>

                        <x-session-messages />

                        <form method="POST" action="{{ translatedRoute('password.store') }}">
                            @csrf
                            @honeypot

                            <input type="hidden" name="token" value="{{ $request->route('token') }}">
                            <input type="hidden" name="email" value="{{ $request->email }}">

                            <x-input.group
                                for="password"
                                :label="__('Password')"
                                :error="$errors->first('password')"
                                :required="true"
                            >
                                <x-input.text
                                    id="password"
                                    name="password"
                                    type="password"
                                    :placeholder="__('*********')"
                                    autocomplete="new-password"
                                />
                            </x-input.group>

                            <x-input.group
                                for="password_confirmation"
                                :label="__('Password confirmation')"
                                :error="$errors->first('password_confirmation')"
                                :required="true"
                            >
                                <x-input.text
                                    id="password_confirmation"
                                    name="password_confirmation"
                                    type="password"
                                    :placeholder="__('*********')"
                                    autocomplete="new-password"
                                />
                            </x-input.group>

                            <button class="button button--secondary mt-4" type="submit">
                                {{ __('Reset password') }}
                            </button>
                        </form>
                    </x-panel>
                </div>

                <div class="col-12 col-lg-6">
                    <x-panel :title="__('No account yet?')">
                        <x-slot:description>
                            <p>{!! __('Create an account to add products and view your cart.') !!}</p>

                            <a href="{{ translatedRoute('register') }}" class="button button--primary">
                                {{ __('Register') }}
                            </a>
                        </x-slot:description>

                        <x-contact-cta />
                    </x-panel>
                </div>
            </div>
        </div>
    </main>
</x-layouts.app>
