@props(['block', 'lazyLoading' => false])

<section class="cta-blocks component-border-radius">
    <div class="container">
        <div class="row gy-4">
            <div class="col-12 col-md-6 col-xl-3">
                <div class="cta-blocks__employee-cta">
                    <div class="employee-cta">
                        @if($image = $block->media->firstWhere('pivot.properties.field', 'contact_image'))
                            <figure>
                                <img
                                    src="{{ $image->getUrl() }}"
                                    alt="{{ $component->data['title'] ?? '' }}"
                                    loading="{{ $lazyLoading ? 'lazy': 'eager' }}"
                                    fetchpriority="{{ $lazyLoading ? 'low': 'high' }}"
                                >
                            </figure>
                        @endif
                        <div class="employee">
                            @isset($block->data['contact_name'])
                                <h3 class="name">{{ $block->data['contact_name'] }}</h3>
                            @endif
                            @isset($block->data['contact_function'])
                                <p class="job-title">{{ $block->data['contact_function'] }}</p>
                            @endif
                        </div>
                    </div>
                    <h2 class="title">{{ __('In need of assistance?') }}</h2>
                    <address class="contact-details">
                        <div class="phone">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="19" height="19" viewBox="0 0 19 19">
                                <defs>
                                    <clipPath id="a">
                                        <rect width="19" height="19" fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                    </clipPath>
                                </defs>
                                <g transform="translate(0 0)">
                                    <g transform="translate(0 0)" clip-path="url(#a)">
                                        <path d="M17.652,15.416,14.1,11.868l-2.259,2.259a12.148,12.148,0,0,1-4.16-2.753,12.175,12.175,0,0,1-2.754-4.16L6.077,6.069a1.487,1.487,0,0,0,.083-2.145L3.645,1.409,1.634,3.415A3.106,3.106,0,0,0,.807,6.207a15.28,15.28,0,0,0,4.339,7.706,15.277,15.277,0,0,0,7.706,4.339,3.106,3.106,0,0,0,2.791-.826Z" transform="translate(-0.021 -0.038)" fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                        <path d="M10.75,4.777A3.837,3.837,0,0,1,13.526,5.9" transform="translate(-0.295 -0.131)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1.5"/>
                                        <path d="M16.275,3.039A7.79,7.79,0,0,0,10.749.75" transform="translate(-0.295 -0.02)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1.5"/>
                                        <path d="M14.727,8.708A3.836,3.836,0,0,0,13.6,5.932" transform="translate(-0.373 -0.162)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1.5"/>
                                        <path d="M16.431,3.1A7.792,7.792,0,0,1,18.72,8.63" transform="translate(-0.451 -0.085)" fill="none" stroke="#fff" stroke-linecap="round" stroke-width="1.5"/>
                                    </g>
                                </g>
                            </svg>
                            <div class="wrapper">
                                <p class="label">{{ __('Call us on') }}</p>
                                <p><a href="tel:{{ app(\Daylight\Core\Settings\General::class)->phoneNumber }}">{{ app(\Daylight\Core\Settings\General::class)->phoneNumber }}</a></p>
                            </div>
                        </div>
                        <div class="mail">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20.001" height="14.262" viewBox="0 0 20.001 14.262">
                                <g transform="translate(0.001 0.201)">
                                    <g transform="translate(0 14.061) rotate(-90)" fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"><rect width="14" height="20" stroke="none"/><rect x="0.75" y="0.75" width="12.5" height="18.5" fill="none"/></g>
                                    <path d="M-8139.545-2542.061l8.818,6.831,8.82-6.831" transform="translate(8140.597 2542.911)" fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                </g>
                            </svg>

                            <div class="wrapper">
                                <p class="label">{{ __('E-mail us on') }}</p>
                                <a href="mailto:{{ app(\Daylight\Core\Settings\General::class)->email }}">
                                    {{ app(\Daylight\Core\Settings\General::class)->email }}
                                </a>
                            </div>
                        </div>
                    </address>
                </div>
            </div>

            <div class="col-12 col-md-6 col-xl-3">
                <div class="cta-blocks__block">
                    @isset($block->data['maintenance_title'])
                        <h3 class="title">{!! $block->data['maintenance_title'] !!}</h3>
                    @endif

                    <div class="stars">
                        <svg xmlns="http://www.w3.org/2000/svg" width="11.126" height="10.622">
                            <g clip-path="url(#a)">
                                <path fill="#ff8126" d="m5.768 9.121 2.755 1.449a.441.441 0 0 0 .639-.464l-.526-3.068a.441.441 0 0 1 .126-.389l2.229-2.173a.44.44 0 0 0-.243-.75l-3.08-.447a.441.441 0 0 1-.332-.24L5.958.245a.441.441 0 0 0-.79 0L3.789 3.037a.439.439 0 0 1-.332.24l-3.08.447a.44.44 0 0 0-.243.75l2.229 2.174a.44.44 0 0 1 .126.389l-.526 3.068a.441.441 0 0 0 .639.464l2.756-1.448a.44.44 0 0 1 .41 0Z"/>
                            </g>
                        </svg>
                        <svg xmlns="http://www.w3.org/2000/svg" width="11.126" height="10.622">
                            <g clip-path="url(#a)">
                                <path fill="#ff8126" d="m5.768 9.121 2.755 1.449a.441.441 0 0 0 .639-.464l-.526-3.068a.441.441 0 0 1 .126-.389l2.229-2.173a.44.44 0 0 0-.243-.75l-3.08-.447a.441.441 0 0 1-.332-.24L5.958.245a.441.441 0 0 0-.79 0L3.789 3.037a.439.439 0 0 1-.332.24l-3.08.447a.44.44 0 0 0-.243.75l2.229 2.174a.44.44 0 0 1 .126.389l-.526 3.068a.441.441 0 0 0 .639.464l2.756-1.448a.44.44 0 0 1 .41 0Z"/>
                            </g>
                        </svg>
                        <svg xmlns="http://www.w3.org/2000/svg" width="11.126" height="10.622">
                            <g clip-path="url(#a)">
                                <path fill="#ff8126" d="m5.768 9.121 2.755 1.449a.441.441 0 0 0 .639-.464l-.526-3.068a.441.441 0 0 1 .126-.389l2.229-2.173a.44.44 0 0 0-.243-.75l-3.08-.447a.441.441 0 0 1-.332-.24L5.958.245a.441.441 0 0 0-.79 0L3.789 3.037a.439.439 0 0 1-.332.24l-3.08.447a.44.44 0 0 0-.243.75l2.229 2.174a.44.44 0 0 1 .126.389l-.526 3.068a.441.441 0 0 0 .639.464l2.756-1.448a.44.44 0 0 1 .41 0Z"/>
                            </g>
                        </svg>
                        <svg xmlns="http://www.w3.org/2000/svg" width="11.126" height="10.622">
                            <g clip-path="url(#a)">
                                <path fill="#ff8126" d="m5.768 9.121 2.755 1.449a.441.441 0 0 0 .639-.464l-.526-3.068a.441.441 0 0 1 .126-.389l2.229-2.173a.44.44 0 0 0-.243-.75l-3.08-.447a.441.441 0 0 1-.332-.24L5.958.245a.441.441 0 0 0-.79 0L3.789 3.037a.439.439 0 0 1-.332.24l-3.08.447a.44.44 0 0 0-.243.75l2.229 2.174a.44.44 0 0 1 .126.389l-.526 3.068a.441.441 0 0 0 .639.464l2.756-1.448a.44.44 0 0 1 .41 0Z"/>
                            </g>
                        </svg>
                        <svg xmlns="http://www.w3.org/2000/svg" width="11.126" height="10.622">
                            <g clip-path="url(#a)">
                                <path fill="#ff8126" d="m5.768 9.121 2.755 1.449a.441.441 0 0 0 .639-.464l-.526-3.068a.441.441 0 0 1 .126-.389l2.229-2.173a.44.44 0 0 0-.243-.75l-3.08-.447a.441.441 0 0 1-.332-.24L5.958.245a.441.441 0 0 0-.79 0L3.789 3.037a.439.439 0 0 1-.332.24l-3.08.447a.44.44 0 0 0-.243.75l2.229 2.174a.44.44 0 0 1 .126.389l-.526 3.068a.441.441 0 0 0 .639.464l2.756-1.448a.44.44 0 0 1 .41 0Z"/>
                            </g>
                        </svg>
                    </div>

                    @isset($block->data['maintenance_content'])
                        {!! $block->data['maintenance_content'] !!}
                    @endif

                    @isset($block->data['maintenance_button'])
                        <a href="{{ $block->data['maintenance_url'] }}" class="link">
                            {{ $block->data['maintenance_button'] }}
                            <svg xmlns="http://www.w3.org/2000/svg" width="10.59" height="9.645" viewBox="0 0 10.59 9.645">
                                <g transform="translate(0.75 1.06)">
                                    <path d="M-14369.2-5007.5h9.09" transform="translate(14369.203 5011.262)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-width="1.5"/>
                                    <path d="M-14359.936-5008.41l3.762-3.762-3.762-3.761" transform="translate(14365.264 5015.934)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                </g>
                            </svg>
                        </a>
                    @endisset
                </div>
            </div>

            <div class="col-12 col-md-6 col-xl-3">
                <div class="cta-blocks__block">
                    @isset($block->data['cta_title'])
                        <h3 class="title">{!! $block->data['cta_title'] !!}</h3>
                    @endif

                    @isset($block->data['cta_usps'])
                        <ul>
                            @foreach($block->data['cta_usps'] as $usp)
                                <li>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="13.764" height="10.036" viewBox="0 0 13.764 10.036">
                                        <path id="Path_47989" data-name="Path 47989"
                                              d="M3526.652-6174.925l3.855,3.854,7.789-8.226"
                                              transform="translate(-3525.592 6180.356)" fill="none" stroke="#ff8126"
                                              stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                    </svg>
                                    {{ $usp['usp'] }}
                                </li>
                            @endforeach
                        </ul>
                    @endif
                </div>
            </div>

            <div class="col-12 col-md-6 col-xl-3">

                <div class="cta-blocks__block">
                    @isset($block->data['stock_title'])
                        <h3 class="title">{!! $block->data['stock_title'] !!}</h3>
                    @endif

                    <svg class="icon" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="63.267" height="83.24" viewBox="0 0 63.267 83.24">
                        <g id="Group_20165" data-name="Group 20165" transform="translate(0 0)">
                            <g id="Group_20164" data-name="Group 20164" transform="translate(0 0)" clip-path="url(#clip-path)">
                                <path id="Path_47999" data-name="Path 47999" d="M.5,16.5l7.416,3.189L19.022,63.333" transform="translate(0.173 5.713)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                <path id="Path_48000" data-name="Path 48000" d="M23.85,58.064a6.734,6.734,0,1,1-6.735-6.735A6.735,6.735,0,0,1,23.85,58.064Z" transform="translate(3.594 17.769)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                <line id="Line_1" data-name="Line 1" y1="7.794" x2="29.724" transform="translate(27.497 66.367)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                <rect id="Rectangle_2916" data-name="Rectangle 2916" width="28.014" height="25.226" transform="matrix(0.966, -0.259, 0.259, 0.966, 16.217, 7.922)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                <rect id="Rectangle_2917" data-name="Rectangle 2917" width="5.783" height="8.627" transform="translate(26.954 5.047) rotate(-15)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                <rect id="Rectangle_2918" data-name="Rectangle 2918" width="34.928" height="31.451" transform="translate(20.716 38.067) rotate(-14.999)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                <rect id="Rectangle_2919" data-name="Rectangle 2919" width="7.211" height="10.756" transform="matrix(0.966, -0.259, 0.259, 0.966, 34.103, 34.48)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                <line id="Line_2" data-name="Line 2" y1="1.8" x2="6.719" transform="translate(31.707 56.647)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                <line id="Line_3" data-name="Line 3" y1="1.8" x2="6.719" transform="translate(32.685 60.298)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                            </g>
                        </g>
                    </svg>

                    @isset($block->data['stock_content'])
                        {!! $block->data['stock_content'] !!}
                    @endif
                </div>
            </div>
        </div>
    </div>
</section>
