@extends('daylight::layouts.app')

@section('title', __('Create new post'))

@section('content')
    <x-daylight::page-header :title="__('Create new post')"/>

    <x-daylight::session-messages/>

    <form method="post" action="{{ route('daylight.content.posts.store') }}" x-data="{ name: '{{ old('name') }}'}">
        @csrf

        <x-daylight::input.group
            :label="__('Locale')"
            :error="$errors->first('locale')"
            for="locale"
        >
            <x-daylight::input.select name="locale" id="locale">
                @foreach(\Daylight\Core\Modules\Multilingualism\Multilingualism::getAvailableLocales() as $locale)
                    <option value="{{ $locale }}" {{ old('locale') === $locale ? 'selected' : '' }}>
                        {{ strtoupper($locale) }}
                    </option>
                @endforeach
            </x-daylight::input.select>
        </x-daylight::input.group>

        <x-daylight::input.group
            :label="__('Image')"
            :error="$errors->first('image')"
            for="image"
        >
            <div wire:ignore>
                <div data-vue-app>
                    <media-selector
                        name="image"
                        :single-file="true"
                        :initial-media='@json(old('image'))'
                    />
                </div>
            </div>
        </x-daylight::input.group>

        <x-daylight::input.group
            :label="__('Name')"
            :error="$errors->first('name')"
            for="name"
        >
            <x-daylight::input.text name="name" id="name" value="{{ old('name') }}" x-model="name"/>
        </x-daylight::input.group>

        <x-daylight::input.group
            :label="__('Slug')"
            :error="$errors->first('slug')"
            :helpText="__('Unique identifier of this page. This must be unique since the page URL will be built on this.')"
            for="slug"
        >
            <x-daylight::input.text name="slug" id="slug" value="{{ old('slug') }}" x-slug="name" readonly/>
        </x-daylight::input.group>

        <x-daylight::input.group
            :label="__('Content')"
            :error="$errors->first('content')"
            for="content"
        >
            <x-daylight::input.wysiwyg name="content" id="content">{{ old('content') }}</x-daylight::input.wysiwyg>
        </x-daylight::input.group>

        <x-daylight::seo />

        <div class="mt-6 flex items-center justify-end gap-x-3">
            <x-daylight::buttons.secondary href="{{ route('daylight.content.posts.index') }}" element="a">
                {{ __('Cancel') }}
            </x-daylight::buttons.secondary>

            <x-daylight::buttons.primary type="submit">
                {{ __('Save') }}
            </x-daylight::buttons.primary>
        </div>
    </form>
@endsection
