@extends('daylight::layouts.app')

@section('title', __('Edit :question', ['question' => $question->name]))

@section('content')
    <div x-data="{ showConfirmDeleteModal: false }">
        <x-daylight::page-header :title="__('Edit :question', ['question' => $question->name])">
            @can('delete:pages')
                <x-daylight::buttons.danger @click.prevent="showConfirmDeleteModal = true">
                    {{ __('Delete question') }}
                </x-daylight::buttons.danger>
            @endif
        </x-daylight::page-header>

        <x-daylight::session-messages/>

        <form method="post" action="{{ route('daylight.content.questions.update', $question) }}">
            @csrf
            @method('PUT')
            <input type="hidden" name="locale" value="{{ request()->get('locale', 'en') }}">

            <x-daylight::input.group
                :label="__('Category')"
                :error="$errors->first('question_category_id')"
                for="question_category_id"
            >
                <x-daylight::input.select name="question_category_id" id="question_category_id">
                    <option value="">{{ __('Select a category') }}</option>
                    @foreach($categories as $category)
                        <option value="{{ $category->id }}" {{ old('question_category_id', $question->question_category_id) == $category->id ? 'selected' : '' }}>
                            {{ $category->name }}
                        </option>
                    @endforeach
                </x-daylight::input.select>
            </x-daylight::input.group>

            <x-daylight::locale-selector :route="route('daylight.content.questions.edit', $question)"/>

            <x-daylight::input.group
                :label="__('Name')"
                :error="$errors->first('name')"
                for="name"
            >
                <x-daylight::input.text name="name" id="name" value="{{ old('name', $question->name) }}" />
            </x-daylight::input.group>

            <x-daylight::input.group
                :label="__('Content')"
                :error="$errors->first('content')"
                for="content"
            >
                <x-daylight::input.textarea name="content" id="content">{{ old('content', $question->content) }}</x-daylight::input.textarea>
            </x-daylight::input.group>

            <div class="mt-6 flex items-center justify-end gap-x-3">
                <x-daylight::buttons.secondary href="{{ route('daylight.content.questions.index') }}" element="a">
                    {{ __('Cancel') }}
                </x-daylight::buttons.secondary>

                <x-daylight::buttons.primary type="submit">
                    {{ __('Save') }}
                </x-daylight::buttons.primary>
            </div>
        </form>

        <x-daylight::modal.confirm-delete-modal>
            <x-slot name="content">
                <h3 class="text-base font-semibold leading-6 text-gray-900" id="modal-title">{{ __('Delete :object', ['object' => __('question')]) }}</h3>
                <div class="mt-2">
                    <p class="text-sm text-gray-500">
                        {{ __('Are you sure you want to delete this :object? This action cannot be undone.', ['object' => __('question')]) }}
                    </p>
                </div>
            </x-slot>

            <x-slot name="footer">
                <form method="post" action="{{ route('daylight.content.questions.destroy', $question) }}">
                    @csrf
                    @method('DELETE')

                    <button type="button" class="mt-3 inline-flex w-full justify-center rounded-md bg-white px-3 py-2 text-sm font-semibold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-100 sm:mt-0 sm:w-auto" @click.prevent="showConfirmDeleteModal = false">
                        {{ __('Cancel') }}
                    </button>

                    <button type="submit" class="inline-flex w-full justify-center rounded-md bg-red-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-500 sm:ml-2 sm:w-auto">
                        {{ __('Delete') }}
                    </button>
                </form>
            </x-slot>
        </x-daylight::modal.confirm-delete-modal>
    </div>
@endsection
