<x-slide-over
    name="search"
    entangle="showSearchSlideOver"
    position="top"
>
    <x-slot:header>
        <div class="slide-over__header slide-over__header--no-border">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="slide-over__header-inner">
                            <div class="slide-over__left">
                                {{ __('Search') }}
                            </div>
                            <div class="slide-over__right">
                                <ul class="slide-over__icons">
                                    <li class="slide-over__offcanvas">
                                        <button @click.prevent="isVisible = !isVisible">
                                            <img src="{{ Vite::asset('resources/images/icons/icon-close.svg') }}"
                                                 alt="{{ __('Close') }}">
                                        </button>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </x-slot:header>

    <div class="container"
        x-data
         x-on:toggle-slide-over.window="$event.detail === 'search' ? setTimeout(() => document.getElementById('search-query-input').focus(), 350) : null"
    >
        <div class="row">
            <div class="col-12">
                <div class="slide-over__search-autocomplete">
                    <x-input.search :searchQuery="$searchQuery" />

                    @if($searchQuery)
                        @if($products->isNotEmpty())
                            <div class="popular-products">
                                <p class="title">{{ __('Results') }}</p>

                                <ul class="list-products-autocomplete">
                                    @foreach($products as $product)
                                        <li>
                                            <a class="card-product-search"
                                               href="{{ translatedRoute('products.show', $product->slug) }}">
                                                @if($product->getFirstMedia())
                                                    <figure>
                                                        <img
                                                            src="{{ $product->getFirstMedia()->getUrl('thumbnail') }}"
                                                            srcset="
                                                                {{ $product->getFirstMedia()->getUrl('thumbnail-2x') }} 2x,
                                                                {{ $product->getFirstMedia()->getUrl('thumbnail') }}
                                                            "
                                                            alt="{{ $product->name }}"
                                                        >
                                                    </figure>
                                                @else
                                                    <img
                                                        src="{{ Vite::asset('resources/images/placeholders/product-image.png') }}"
                                                        alt="{{ $product->name }}"/>
                                                @endif
                                                <div class="card-product-search__content">
                                                    <h3 class="product-title">{{ $product->name }}</h3>
                                                    <div class="product-price">
                                                        <span class="price">{{ formatPrice($product->price) }}</span>
                                                        <span class="label-vat">{{ __('excl. VAT') }}</span>
                                                    </div>
                                                </div>
                                            </a>
                                        </li>
                                    @endforeach
                                </ul>

                                <a href="{{ translatedRoute('products.index', ['q' => $searchQuery ]) }}"
                                   class="button button--primary">
                                    {{ __('View all results') }}
                                </a>
                            </div>
                        @else
                            <p>{{ __('No results found matching your search query.') }}</p>
                        @endif
                    @else
{{--                        <div class="popular-searches">--}}
{{--                            <p class="title">{{ __('Popular search results') }}</p>--}}

{{--                            <ul class="list-search-autocomplete">--}}
{{--                                <li>--}}
{{--                                    <button class="filter">Assortiment</button>--}}
{{--                                </li>--}}
{{--                                <li>--}}
{{--                                    <button class="filter">Gasdrukregelaars</button>--}}
{{--                                </li>--}}
{{--                                <li>--}}
{{--                                    <button class="filter">Merken</button>--}}
{{--                                </li>--}}
{{--                                <li>--}}
{{--                                    <button class="filter">Service en onderhoud</button>--}}
{{--                                </li>--}}
{{--                                <li>--}}
{{--                                    <button class="filter">Contact</button>--}}
{{--                                </li>--}}
{{--                            </ul>--}}
{{--                        </div>--}}

{{--                        <div class="popular-products">--}}
{{--                            <p class="title">{{ __('Popular products') }}</p>--}}

{{--                            <ul class="list-products-autocomplete">--}}
{{--                                @for ($i = 0; $i < 12; $i++)--}}
{{--                                    <li>--}}
{{--                                        <article class="card-product-search">--}}
{{--                                            <figure>--}}
{{--                                                <img--}}
{{--                                                    src="{{ Vite::asset('resources/images/placeholders/product-image.png') }}"--}}
{{--                                                    alt="Product {{ $i + 1 }}">--}}
{{--                                            </figure>--}}
{{--                                            <div class="card-product-search__content">--}}
{{--                                                <h3 class="product-title">Afblaasveiligheid Elster type J48K</h3>--}}
{{--                                                <div class="product-price">--}}
{{--                                                    <span class="price">€ 105,99</span>--}}
{{--                                                    <span class="label-vat">excl. VAT</span>--}}
{{--                                                </div>--}}
{{--                                            </div>--}}
{{--                                        </article>--}}
{{--                                    </li>--}}
{{--                                @endfor--}}
{{--                            </ul>--}}

{{--                            <a href="{{ translatedRoute('products.index') }}" class="button button--primary">--}}
{{--                                {{ __('View all products') }}--}}
{{--                            </a>--}}
{{--                        </div>--}}
                    @endif
                </div>
            </div>
        </div>
    </div>
</x-slide-over>

@script
<script>
    // window on toggle-slide-over
    window.addEventListener('toggle-slide-over', event => {
        if (event.detail.name === 'search') {
            console.log('yo')
        }
    });
</script>
@endscript
