<?php

use App\Daylight\Http\Controllers\Content\PostController as DaylightPostController;
use App\Daylight\Http\Controllers\Content\QuestionCategoryController;
use App\Daylight\Http\Controllers\Content\QuestionController;
use App\Daylight\Http\Controllers\Content\TestimonialController;
use App\Daylight\Http\Controllers\Settings\UspsController;
use App\Http\Controllers\Account\AccountController;
use App\Http\Controllers\Account\AddressController;
use App\Http\Controllers\Account\OrderController;
use App\Http\Controllers\Account\PasswordController;
use App\Http\Controllers\Auth\ForgotPasswordController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\Auth\ResetPasswordController;
use App\Http\Controllers\Auth\VerificationController;
use App\Http\Controllers\CartController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\CheckoutController;
use App\Http\Controllers\CheckoutStatusController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\PostController;
use App\Http\Controllers\ProductController;
use App\Modules\Wishlist\Http\Controllers\WishlistController;
use Daylight\Core\Modules\Multilingualism\Multilingualism;
use Illuminate\Support\Facades\Route;

Route::daylight();

Route::get('/admin/settings/usps', [UspsController::class, 'index'])
    ->name('daylight.settings.usps.index')
    ->middleware('can:read:settings');
Route::put('/admin/settings/usps', [UspsController::class, 'update'])
    ->name('daylight.settings.usps.update')
    ->middleware('can:update:settings');

Route::resource('/admin/content/testimonials', TestimonialController::class)->names('daylight.content.testimonials');
Route::resource('/admin/content/posts', DaylightPostController::class)->names('daylight.content.posts');
Route::resource('/admin/content/questions', QuestionController::class)->names('daylight.content.questions');
Route::resource('/admin/content/question-categories', QuestionCategoryController::class)->names('daylight.content.question-categories');

Route::get('/', PageController::class)
    ->middleware('verified')
    ->name('home');

Multilingualism::getAvailableLocales()->reverse()->each(function (string $locale) {
    $prefix = $locale === config('multilingualism.default_locale') ? '' : $locale;

    Route::prefix($prefix)
        ->middleware(['cart', 'wishlist'])
        ->group(function () use ($locale) {
            Route::middleware(['guest', 'honeypot'])
                ->group(function () use ($locale) {
                    Route::get(__('routes.auth.login', [], $locale), [LoginController::class, 'create'])->name($locale.'_login');
                    Route::post(__('routes.auth.login', [], $locale), [LoginController::class, 'store']);

                    Route::get(__('routes.auth.register', [], $locale), [RegisterController::class, 'create'])->name($locale.'_register');
                    Route::post(__('routes.auth.register', [], $locale), [RegisterController::class, 'store']);

                    Route::get(__('routes.auth.forgot-password', [], $locale), [ForgotPasswordController::class, 'create'])
                        ->name($locale.'_password.forgot');
                    Route::post(__('routes.auth.forgot-password', [], $locale), [ForgotPasswordController::class, 'store']);

                    Route::get(__('routes.auth.reset-password', [], $locale).'/{token}', [ResetPasswordController::class, 'create'])
                        ->name($locale.'_password.reset');
                    Route::post(__('routes.auth.reset-password', [], $locale), [ResetPasswordController::class, 'store'])
                        ->name($locale.'_password.store');
                });

            Route::middleware('auth')
                ->group(function () use ($locale) {
                    Route::get(__('routes.verification.verify-email', [], $locale).'/{id}/{hash}', [VerificationController::class, 'verify'])
                        ->middleware(['signed', 'throttle:6,1'])
                        ->name($locale.'_verification.verify');

                    Route::get(__('routes.verification.verify-email', [], $locale), [VerificationController::class, 'unverified'])
                        ->name($locale.'_verification.notice');

                    Route::post(__('routes.verification.verify-email', [], $locale), [VerificationController::class, 'resendVerification'])
                        ->middleware('throttle:6,1')
                        ->name($locale.'_verification.send');

                    Route::post(__('routes.auth.logout', [], $locale), [LoginController::class, 'destroy'])
                        ->middleware('auth')
                        ->name($locale.'_logout');
                });

            Route::middleware(['auth', 'verified'])
                ->group(function () use ($locale) {
                    Route::get(__('routes.account', [], $locale), [AccountController::class, 'index'])->name($locale.'_account.index');
                    Route::post(__('routes.account', [], $locale), [AccountController::class, 'update']);

                    Route::get(__('routes.account.password', [], $locale), [PasswordController::class, 'index'])->name($locale.'_account.password');
                    Route::post(__('routes.account.password', [], $locale), [PasswordController::class, 'update']);

                    Route::get(__('routes.account.addresses', [], $locale), [AddressController::class, 'index'])->name($locale.'_account.addresses.index');
                    Route::get(__('routes.account.addresses.create', [], $locale), [AddressController::class, 'create'])->name($locale.'_account.addresses.create');
                    Route::get(__('routes.account.addresses', [], $locale).'/{address}/edit', [AddressController::class, 'edit'])->name($locale.'_account.addresses.edit');

                    Route::post(__('routes.account.addresses', [], $locale), [AddressController::class, 'store'])->name($locale.'_account.addresses.store');
                    Route::put(__('routes.account.addresses', [], $locale).'/{address}', [AddressController::class, 'update'])->name($locale.'_account.addresses.update');
                    Route::delete(__('routes.account.addresses', [], $locale).'/{address}', [AddressController::class, 'destroy'])->name($locale.'_account.addresses.destroy');

                    Route::get(__('routes.account.orders', [], $locale), [OrderController::class, 'index'])->name($locale.'_account.orders.index');
                    Route::get(__('routes.account.orders.show', [], $locale).'/{order:uuid}', [OrderController::class, 'show'])->name($locale.'_account.orders.show');
                });

            Route::middleware('verified')
                ->group(function () use ($locale) {
                    Route::get(__('routes.wishlist', [], $locale), WishlistController::class)->name($locale.'_wishlist.index');
                    Route::get(__('routes.cart', [], $locale), CartController::class)->name($locale.'_cart.index');
                    Route::get(__('routes.checkout', [], $locale), CheckoutController::class)->name($locale.'_checkout.index');
                    Route::get(__('routes.checkout.status', [], $locale).'/{orderUuid}', CheckoutStatusController::class)->name($locale.'_checkout.status');

                    Route::prefix(__('routes.products', [], $locale))->group(function () use ($locale) {
                        Route::get('/', [ProductController::class, 'index'])->name($locale.'_products.index');

                        Route::get('/{any}', CategoryController::class)
                            ->name($locale.'_products.category')
                            ->where('any', '^[a-zA-Z0-9-_\/]+$');
                    });

                    Route::get(__('routes.product', [], $locale).'/{any}', [ProductController::class, 'show'])->name($locale.'_products.show');
                    Route::get(__('routes.news.show', [], $locale).'/{slug}', PostController::class)->name($locale.'_news.show');

                    Route::get('/{any?}', PageController::class)->name($locale.'_page');
                });
        });
});

Route::fallback(function () {
    return view('errors.404');
});
