<?php

namespace App\Components;

use Daylight\Core\Modules\PageBuilder\Entities\Component;
use Daylight\Core\Modules\PageBuilder\Entities\Field;
use Illuminate\Support\Collection;

class Content extends Component
{
    public string $type = 'content';

    public function name(): string
    {
        return __('Content');
    }

    public function fields(): Collection
    {
        return collect([
            Field::select('sizing', __('Sizing'), [
                'narrow' => __('Narrow'),
                'wide' => __('Wide'),
            ])->required(),
            Field::wysiwyg('content', __('Content'))->required(),
            Field::repeater('buttons', __('Buttons'), [
                Field::select('type', __('Type'), [
                    'primary' => __('Primary'),
                    'secondary' => __('Secondary'),
                    'tertiary' => __('Tertiary'),
                ]),
                Field::text('label', __('Label'))->required(),
                Field::text('url', __('URL'))->required(),
            ])->required(),
        ]);
    }
}
