<?php

namespace App\Components;

use Daylight\Core\Modules\PageBuilder\Entities\Component;
use Daylight\Core\Modules\PageBuilder\Entities\Field;
use Illuminate\Support\Collection;

class ContentImage extends Component
{
    public string $type = 'content-image';

    public function name(): string
    {
        return __('Content - Image');
    }

    public function fields(): Collection
    {
        return collect([
            Field::select('background', __('Background'), [
                'white' => __('White'),
                'gray' => __('Gray'),
            ])->required(),
            Field::media('image', __('Image')),
            Field::text('title', __('Title'))->required(),
            Field::wysiwyg('content', __('Content'))->required(),
        ]);
    }
}
