<?php

namespace App\Components;

use Daylight\Core\Modules\PageBuilder\Entities\Component;
use Daylight\Core\Modules\PageBuilder\Entities\Field;
use Illuminate\Support\Collection;

class Hero extends Component
{
    public string $type = 'hero';

    public function name(): string
    {
        return __('Hero');
    }

    public function fields(): Collection
    {
        return collect([
            Field::media('image', __('Image')),
            Field::text('title', __('Title'))->required(),
            Field::repeater('assortment', __('Assortment'), [
                Field::text('label', __('Label'))->required(),
                Field::text('url', __('URL'))->required(),
            ]),
            Field::button('button', __('Button')),
            Field::button('secondary_button', __('Secondary button')),
        ]);
    }
}
