<?php

namespace App\Console\Commands;

use Daylight\Core\Models\Brand;
use Daylight\Core\Models\Category;
use Daylight\Core\Models\Option;
use Daylight\Core\Models\Product;
use Daylight\Core\Modules\MediaLibrary\Models\Media;
use Daylight\Core\Modules\Multilingualism\Multilingualism;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class InsertExampleData extends Command
{
    protected $signature = 'app:insert-example-data';

    protected $description = 'Inserts example products for testing purposes';

    public function handle()
    {
        $this->createMedia();
        $this->createBrand();

        DB::transaction(function () {
            $product = Product::create([
                'brand_id' => 1,
                'status' => 1,
            ]);

            $product->media()->attach([1]);

            $product->translations()->create([
                'locale' => 'en',
                'slug' => 'new-balance-fresh-foam-contend-v2',
                'name' => 'New Balance Fresh Foam Contend V2',
                'description' => 'Golf Shoes New Balance Fresh Foam Contend V2: Comfort and Performance For Modern Golfers. Discover the latest addition to our assortment: golf shoes New Balance Fresh Foam Contend V2. This iconic sports brand offers more than 100 years of history and an impressive archive of sneaker designs. The Fresh Foam Contend V2 is specifically designed to meet the needs of the modern golfer, with signature NB technology and updates to golf-specific design.',
            ]);

            $product->translations()->create([
                'locale' => 'nl',
                'slug' => 'new-balance-fresh-foam-contend-v2',
                'name' => 'New Balance Fresh Foam Contend V2',
                'description' => 'Golfschoenen New Balance Fresh Foam Contend V2: Comfort en Prestatie Voor Moderne Golfers. Ontdek de nieuwste toevoeging aan ons assortiment: Golfschoenen New Balance Fresh Foam Contend V2. Deze iconische sportmerk biedt meer dan 100 jaar geschiedenis en een indrukwekkend archief van sneakerontwerpen. De Fresh Foam Contend V2 is speciaal ontworpen om te voldoen aan de behoeften van de moderne golfer, met handtekening NB-technologie en updates voor golf-specifiek ontwerp.',
            ]);

            $product->variants()->createMany([
                [
                    'sku' => 'NB-FFC-BLACK-40',
                    'stock' => rand(0, 15),
                    'purchasable' => 1,
                    'weight' => 500,
                    'tax_class_id' => 1,
                ],
                [
                    'sku' => 'NB-FFC-BLACK-41',
                    'stock' => rand(0, 15),
                    'purchasable' => 1,
                    'weight' => 500,
                    'tax_class_id' => 1,
                ],
                [
                    'sku' => 'NB-FFC-BLACK-42',
                    'stock' => rand(0, 15),
                    'purchasable' => 1,
                    'weight' => 500,
                    'tax_class_id' => 1,
                ],
                [
                    'sku' => 'NB-FFC-BLACK-43',
                    'stock' => rand(0, 15),
                    'purchasable' => 1,
                    'weight' => 500,
                    'tax_class_id' => 1,
                ],
                [
                    'sku' => 'NB-FFC-BLACK-44',
                    'stock' => rand(0, 15),
                    'purchasable' => 1,
                    'weight' => 500,
                    'tax_class_id' => 1,
                ],
                [
                    'sku' => 'NB-FFC-BLACK-45',
                    'stock' => rand(0, 15),
                    'purchasable' => 1,
                    'weight' => 500,
                    'tax_class_id' => 1,
                ],

                [
                    'sku' => 'NB-FFC-NAVY-40',
                    'stock' => rand(0, 15),
                    'purchasable' => 1,
                    'weight' => 500,
                    'tax_class_id' => 1,
                ],
                [
                    'sku' => 'NB-FFC-NAVY-41',
                    'stock' => rand(0, 15),
                    'purchasable' => 1,
                    'weight' => 500,
                    'tax_class_id' => 1,
                ],
                [
                    'sku' => 'NB-FFC-NAVY-42',
                    'stock' => rand(0, 15),
                    'purchasable' => 1,
                    'weight' => 500,
                    'tax_class_id' => 1,
                ],
                [
                    'sku' => 'NB-FFC-NAVY-43',
                    'stock' => rand(0, 15),
                    'purchasable' => 1,
                    'weight' => 500,
                    'tax_class_id' => 1,
                ],
                [
                    'sku' => 'NB-FFC-NAVY-44',
                    'stock' => rand(0, 15),
                    'purchasable' => 0,
                    'weight' => 500,
                    'tax_class_id' => 1,
                ],
                [
                    'sku' => 'NB-FFC-NAVY-45',
                    'stock' => rand(0, 15),
                    'purchasable' => 0,
                    'weight' => 500,
                    'tax_class_id' => 1,
                ],

                [
                    'sku' => 'NB-FFC-GREY-40',
                    'stock' => rand(0, 15),
                    'purchasable' => 1,
                    'weight' => 500,
                    'tax_class_id' => 1,
                ],
                [
                    'sku' => 'NB-FFC-GREY-41',
                    'stock' => rand(0, 15),
                    'purchasable' => 1,
                    'weight' => 500,
                    'tax_class_id' => 1,
                ],
                [
                    'sku' => 'NB-FFC-GREY-42',
                    'stock' => rand(0, 15),
                    'purchasable' => 1,
                    'weight' => 500,
                    'tax_class_id' => 1,
                ],
                [
                    'sku' => 'NB-FFC-GREY-43',
                    'stock' => rand(0, 15),
                    'purchasable' => 1,
                    'weight' => 500,
                    'tax_class_id' => 1,
                ],
                [
                    'sku' => 'NB-FFC-GREY-44',
                    'stock' => rand(0, 15),
                    'purchasable' => 0,
                    'weight' => 500,
                    'tax_class_id' => 1,
                ],
                [
                    'sku' => 'NB-FFC-GREY-45',
                    'stock' => rand(0, 15),
                    'purchasable' => 0,
                    'weight' => 500,
                    'tax_class_id' => 1,
                ],
            ]);

            $product->variants()->get()->each(function ($variant) {
                $variant->shippingClasses()->attach(1);

                $images = match (true) {
                    str_contains($variant->sku, 'NAVY') => [1, 2],
                    str_contains($variant->sku, 'GREY') => [3, 4, 5],
                    str_contains($variant->sku, 'BLACK') => [2],
                };

                $variant->media()->attach($images);

                $price = match (true) {
                    str_contains($variant->sku, 'NAVY') => 95.99,
                    str_contains($variant->sku, 'GREY') => 124.99,
                    str_contains($variant->sku, 'BLACK') => 105.99,
                };

                $variant->prices()->create([
                    'price' => $price,
                ]);
            });

            tap(Option::create([
                'type' => 'select',
            ]), function (Option $option) {
                $option->translations()->create([
                    'locale' => 'en',
                    'name' => 'Color',
                ]);

                $option->translations()->create([
                    'locale' => 'nl',
                    'name' => 'Kleur',
                ]);

                tap($option->values()->create(['position' => 1]), function ($value) {
                    $value->translations()->create([
                        'locale' => 'en',
                        'name' => 'Black',
                    ]);

                    $value->translations()->create([
                        'locale' => 'nl',
                        'name' => 'Zwart',
                    ]);
                });

                tap($option->values()->create(['position' => 2]), function ($value) {
                    $value->translations()->create([
                        'locale' => 'en',
                        'name' => 'Navy',
                    ]);

                    $value->translations()->create([
                        'locale' => 'nl',
                        'name' => 'Navy',
                    ]);
                });

                tap($option->values()->create(['position' => 2]), function ($value) {
                    $value->translations()->create([
                        'locale' => 'en',
                        'name' => 'Grey',
                    ]);

                    $value->translations()->create([
                        'locale' => 'nl',
                        'name' => 'Grijs',
                    ]);
                });
            });

            tap(Option::create([
                'type' => 'select',
            ]), function (Option $option) {
                $option->translations()->create([
                    'locale' => 'en',
                    'name' => 'Size',
                ]);

                $option->translations()->create([
                    'locale' => 'nl',
                    'name' => 'Maat',
                ]);

                tap($option->values()->create(['position' => 1]), function ($value) {
                    $value->translations()->create([
                        'locale' => 'en',
                        'name' => '40',
                    ]);

                    $value->translations()->create([
                        'locale' => 'nl',
                        'name' => '40',
                    ]);
                });

                tap($option->values()->create(['position' => 2]), function ($value) {
                    $value->translations()->create([
                        'locale' => 'en',
                        'name' => '41',
                    ]);

                    $value->translations()->create([
                        'locale' => 'nl',
                        'name' => '41',
                    ]);
                });

                tap($option->values()->create(['position' => 3]), function ($value) {
                    $value->translations()->create([
                        'locale' => 'en',
                        'name' => '42',
                    ]);

                    $value->translations()->create([
                        'locale' => 'nl',
                        'name' => '42',
                    ]);
                });

                tap($option->values()->create(['position' => 4]), function ($value) {
                    $value->translations()->create([
                        'locale' => 'en',
                        'name' => '43',
                    ]);

                    $value->translations()->create([
                        'locale' => 'nl',
                        'name' => '43',
                    ]);
                });

                tap($option->values()->create(['position' => 4]), function ($value) {
                    $value->translations()->create([
                        'locale' => 'en',
                        'name' => '44',
                    ]);

                    $value->translations()->create([
                        'locale' => 'nl',
                        'name' => '44',
                    ]);
                });

                tap($option->values()->create(['position' => 4]), function ($value) {
                    $value->translations()->create([
                        'locale' => 'en',
                        'name' => '45',
                    ]);

                    $value->translations()->create([
                        'locale' => 'nl',
                        'name' => '45',
                    ]);
                });
            });

            DB::table('option_value_variant')
                ->insert([
                    ['option_value_id' => 1, 'variant_id' => 1], // Zwart
                    ['option_value_id' => 4, 'variant_id' => 1], // 40

                    ['option_value_id' => 1, 'variant_id' => 2], // Zwart
                    ['option_value_id' => 5, 'variant_id' => 2], // 41

                    ['option_value_id' => 1, 'variant_id' => 3], // Zwart
                    ['option_value_id' => 6, 'variant_id' => 3], // 42

                    ['option_value_id' => 1, 'variant_id' => 4], // Zwart
                    ['option_value_id' => 7, 'variant_id' => 4], // 43

                    ['option_value_id' => 1, 'variant_id' => 5], // Zwart
                    ['option_value_id' => 8, 'variant_id' => 5], // 44

                    ['option_value_id' => 1, 'variant_id' => 6], // Zwart
                    ['option_value_id' => 9, 'variant_id' => 6], // 45

                    ['option_value_id' => 2, 'variant_id' => 7], // Navy
                    ['option_value_id' => 4, 'variant_id' => 7], // 40

                    ['option_value_id' => 2, 'variant_id' => 8], // Navy
                    ['option_value_id' => 5, 'variant_id' => 8], // 41

                    ['option_value_id' => 2, 'variant_id' => 9], // Navy
                    ['option_value_id' => 6, 'variant_id' => 9], // 42

                    ['option_value_id' => 2, 'variant_id' => 10], // Navy
                    ['option_value_id' => 7, 'variant_id' => 10], // 43

                    ['option_value_id' => 2, 'variant_id' => 11], // Navy
                    ['option_value_id' => 8, 'variant_id' => 11], // 44

                    ['option_value_id' => 2, 'variant_id' => 12], // Navy
                    ['option_value_id' => 9, 'variant_id' => 12], // 45

                    ['option_value_id' => 3, 'variant_id' => 13], // Grey
                    ['option_value_id' => 4, 'variant_id' => 13], // 40

                    ['option_value_id' => 3, 'variant_id' => 14], // Grey
                    ['option_value_id' => 5, 'variant_id' => 14], // 41

                    ['option_value_id' => 3, 'variant_id' => 15], // Grey
                    ['option_value_id' => 6, 'variant_id' => 15], // 42

                    ['option_value_id' => 3, 'variant_id' => 16], // Grey
                    ['option_value_id' => 7, 'variant_id' => 16], // 43

                    ['option_value_id' => 3, 'variant_id' => 17], // Grey
                    ['option_value_id' => 8, 'variant_id' => 17], // 44

                    ['option_value_id' => 3, 'variant_id' => 18], // Grey
                    ['option_value_id' => 9, 'variant_id' => 18], // 45

                ]);

            $product->categories()->attach(
                Category::get()
            );
        });

        DB::transaction(function () {
            $product = Product::create([
                'brand_id' => 1,
                'status' => 2,
            ]);

            $product->media()->attach([1, 2, 3, 4]);

            $product->translations()->create([
                'locale' => 'en',
                'slug' => 'fastfold-mission-50-golftrolley',
                'name' => 'FastFold Mission 5.0 Golftrolley',
                'description' => 'This is the FastFold Mission 5.0 3-wheel trolley with its recognizable design. Very stable due to its low center of gravity, sturdy, and very practical to use. Easily foldable into a very compact package. Top trolley, available in many colors! This is the FastFold Mission 5.0 3-wheel trolley with its recognizable design. Very stable due to its low center of gravity, sturdy, and very practical to use. Easily foldable into a very compact package. Top trolley, available in many colors! It looks a lot like that other popular golf trolley but has been tightened up in various ways.',
            ]);

            $product->translations()->create([
                'locale' => 'nl',
                'slug' => 'fastfold-mission-50-golftrolley',
                'name' => 'FastFold Mission 5.0 Golftrolley',
                'description' => 'Dit is de FastFold Mission 5.0 3-wiels trolley met zijn herkenbare design. Lekker stabiel door het lage zwaartepunt, stevig, en erg praktisch in gebruik. Eenvoudig inklapbaar tot erg compact pakketje. Toptrolley, in vele kleuren verkrijgbaar! Dit is de FastFold Mission 5.0 3-wiels trolley met zijn herkenbare design. Lekker stabiel door het lage zwaartepunt, stevig, en erg praktisch in gebruik. Eenvoudig inklapbaar tot erg compact pakketje. Toptrolley, in vele kleuren verkrijgbaar! Hij lijkt veel op "die andere populaire golftrolley" maar is op diverse punten wat aangescherpt.',
            ]);

            $variant = $product->variants()->create([
                'sku' => 'FFM-50-9L',
                'stock' => 500,
                'purchasable' => 1,
                'weight' => 7200,
                'tax_class_id' => 1,
            ]);

            $variant->prices()->create([
                'price' => 149.99,
            ]);
        });
    }

    public function createBrand(): self
    {
        $brand = Brand::create([
            'name' => 'Adidas',
        ]);

        Multilingualism::getAvailableLocales()->each(function ($locale) use ($brand) {
            $brand->translations()->create([
                'locale' => $locale,
                'meta_title' => 'Adidas',
                'meta_description' => 'Adidas brand description',
            ]);
        });

        return $this;
    }

    public function createMedia(): self
    {
        for ($i = 1; $i <= 6; $i++) {
            Media::create([
                'name' => 'image-'.$i.'.png',
                'size' => 5350,
                'type' => 'image/png',
                'handle' => config('services.bytescale.path').'/image-'.$i.'.png',
            ]);
        }

        return $this;
    }

    public function createProduct(): self
    {
        $product = Product::create([
            'brand_id' => 27,
            'status' => 2,
        ]);

        $product->media()->attach([1]);

        $product->translations()->create([
            'locale' => 'en',
            'slug' => 'example-product',
            'name' => 'Example product',
            'description' => 'This is an example product description.',
        ]);

    }
}
