<?php

namespace App\Daylight;

use App\Daylight\Livewire\Content\PostTable;
use App\Daylight\Livewire\Content\QuestionCategoryTable;
use App\Daylight\Livewire\Content\QuestionTable;
use App\Daylight\Livewire\Content\TestimonialTable;
use Daylight\Core\Modules\Admin\Entities\Divider;
use Daylight\Core\Modules\Admin\Entities\Page;
use Daylight\Core\Modules\Admin\Registries\NavigationRegistry;
use Illuminate\Support\ServiceProvider;
use Livewire\Livewire;

class AdminServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        $this
            ->registerTestimonials()
            ->registerNews()
            ->registerFAQ()
            ->registerUspSettings();
    }

    public function registerTestimonials(): self
    {
        NavigationRegistry::addPage(
            Page::create()
                ->setParent('content')
                ->setOrder(300)
                ->setKey('testimonials')
                ->setLabel(__('Testimonials'))
                ->setPermission('view:administration')
                ->setIcon('o-settings')
                ->setRoute('daylight.content.testimonials.index')
        );

        Livewire::component('daylight::testimonial-table', TestimonialTable::class);

        return $this;
    }

    public function registerNews(): self
    {
        NavigationRegistry::addPage(
            Page::create()
                ->setParent('content')
                ->setOrder(400)
                ->setKey('posts')
                ->setLabel(__('Posts'))
                ->setPermission('view:administration')
                ->setIcon('o-settings')
                ->setRoute('daylight.content.posts.index')
        );

        Livewire::component('daylight::post-table', PostTable::class);

        return $this;
    }

    public function registerFAQ(): self
    {

        NavigationRegistry::addPage(
            Divider::create()
                ->setParent('content')
                ->setLabel(__('FAQ'))
                ->setOrder(600)
        );

        NavigationRegistry::addPage(
            Page::create()
                ->setParent('content')
                ->setOrder(700)
                ->setKey('questions')
                ->setLabel(__('Questions'))
                ->setPermission('view:administration')
                ->setIcon('o-settings')
                ->setRoute('daylight.content.questions.index')
        );

        NavigationRegistry::addPage(
            Page::create()
                ->setParent('content')
                ->setOrder(700)
                ->setKey('faq_categories')
                ->setLabel(__('Categories'))
                ->setPermission('view:administration')
                ->setIcon('o-settings')
                ->setRoute('daylight.content.question-categories.index')
        );

        Livewire::component('daylight::question-table', QuestionTable::class);
        Livewire::component('daylight::question-category-table', QuestionCategoryTable::class);

        return $this;
    }

    public function registerUspSettings(): self
    {
        NavigationRegistry::addPage(
            Page::create()
                ->setParent('settings')
                ->setOrder(100)
                ->setKey('usps')
                ->setLabel(__('USP\'s'))
                ->setPermission('view:administration')
                ->setIcon('o-settings')
                ->setRoute('daylight.settings.usps.index')
        );

        return $this;
    }
}
