<?php

namespace App\Daylight\Http\Requests\Content\QuestionCategories;

use Illuminate\Foundation\Http\FormRequest;

class UpdateQuestionCategoryRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->user()->can('update:pages');
    }

    public function rules(): array
    {
        return [
            'locale' => ['required', 'string', 'max:10'],
            'name' => ['required', 'string', 'max:255'],
        ];
    }
}
