<?php

namespace App\Daylight\Livewire\Content;

use App\Models\Testimonial;
use Daylight\Core\Livewire\Tables\BaseTable;
use Daylight\Core\Livewire\Tables\Concerns\WithMultilingualism;
use Daylight\Core\Livewire\Tables\Concerns\WithSearch;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Log;
use Illuminate\View\View;
use Livewire\Attributes\Computed;

class TestimonialTable extends BaseTable
{
    //    use WithBulkActions;
    use WithMultilingualism;
    use WithSearch;

    protected function getBaseQuery(): Builder
    {
        return Testimonial::query()
            ->with('translations');
    }

    protected function applySearch(Builder $query, ?string $searchQuery): Builder
    {
        return $query->when($searchQuery, function ($query, $searchQuery) {
            $query->whereHas('translations', function ($query) use ($searchQuery) {
                $query->where('name', 'like', "%{$searchQuery}%");
            });
        });
    }

    protected function applyMultilingualism(Builder $query, ?string $locale): Builder
    {
        return $query->withWhereHas('translations', function ($query) use ($locale) {
            $query->where('locale', $locale);
        });
    }

    #[Computed]
    protected function availableBulkActions(): array
    {
        return [
            'dump' => [
                'name' => __('Dump'),
                'action' => 'dumpSelectedIds',
            ],
        ];
    }

    public function dumpSelectedIds(): void
    {
        Log::debug('Selected IDs: '.json_encode($this->selectedIds));
    }

    public function render(): View
    {
        return view('daylight.content.testimonial-table');
    }
}
