<?php

namespace App\Http\Controllers\Account;

use App\Http\Controllers\Controller;
use App\Http\Requests\Account\UpdatePasswordRequest;
use Daylight\Core\Modules\Multilingualism\Entities\LocalizedRoute;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\View\View;

class PasswordController extends Controller
{
    public function index(): View
    {
        $localizedRoute = LocalizedRoute::create()
            ->setRoute('account.password')
            ->staticRoute();

        return view('account.password', [
            'user' => auth()->user(),
            'localizedRoute' => $localizedRoute,
        ]);
    }

    public function update(UpdatePasswordRequest $request): RedirectResponse
    {
        $request->user()->update([
            'password' => Hash::make($request->get('password')),
        ]);

        Auth::logoutOtherDevices($request->get('current_password'));

        return redirect()
            ->translatedRoute('account.password')
            ->with('success', __('Password changed successfully. All other devices have been signed off.'));
    }
}
