<?php

namespace App\Http\Requests\Account\Addresses;

use Illuminate\Foundation\Http\FormRequest;

class StoreAddressRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->check();
    }

    public function rules(): array
    {
        return [
            'type' => ['required', 'string', 'in:billing,shipping'],
            'name' => ['required', 'string', 'max:255'],
            'kvk_number' => ['required_if:type,billing', 'string', 'max:255'],
            'vat_number' => ['required_if:type,billing', 'string', 'max:255'],
            'address_line_1' => ['required', 'string', 'max:255'],
            'address_line_2' => ['nullable', 'string', 'max:255'],
            'postal_code' => ['required', 'string', 'max:10'],
            'city' => ['required', 'string', 'max:255'],
            'country_id' => ['required', 'exists:countries,id'],
            'default' => ['nullable', 'boolean'],
        ];
    }
}
