<?php

namespace App\Modules\Wishlist\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Modules\Wishlist\Contracts\WishlistInterface;
use Daylight\Core\Modules\Multilingualism\Entities\LocalizedRoute;

class WishlistController extends Controller
{
    public function __construct(
        protected WishlistInterface $wishlist
    ) {
        //
    }

    public function __invoke()
    {
        $localizedRoute = LocalizedRoute::create()
            ->setRoute('wishlist.index')
            ->staticRoute();

        return view('wishlist.index', [
            'localizedRoute' => $localizedRoute,
            'products' => $this->wishlist->getQuery()
                ->with([
                    'translations' => function ($query) {
                        $query->where('locale', app()->getLocale());
                    },
                ])
                ->paginate(16),
        ]);
    }
}
