<?php

namespace App\Modules\Wishlist\Livewire\Wishlist;

use App\Modules\Wishlist\Contracts\WishlistInterface;
use App\Modules\Wishlist\Wishlist;
use Illuminate\View\View;
use Livewire\Attributes\On;
use Livewire\Component;

class Button extends Component
{
    public function wishlist(): Wishlist
    {
        return app(WishlistInterface::class);
    }

    #[On('wishlist-updated')]
    public function render(): View
    {
        return view('livewire.wishlist.button');
    }

    public function placeholder(): View
    {
        return view('livewire.wishlist.button-placeholder');
    }
}
