<?php

namespace App\Providers;

use App\Components\Breadcrumbs;
use App\Components\Content;
use App\Components\ContentColumns;
use App\Components\ContentImage;
use App\Components\CTA;
use App\Components\CTABlocks;
use App\Components\CustomerService;
use App\Components\Gallery;
use App\Components\Hero;
use App\Components\HeroImage;
use App\Components\ImageBanner;
use App\Components\ImageCTA;
use App\Components\PageHeader;
use App\Components\ProductSlider;
use App\Components\TemplateContent;
use App\Components\Testimonials;
use Daylight\Core\Modules\MenuBuilder\Menu;
use Daylight\Core\Modules\MenuBuilder\Menu as MenuEntity;
use Daylight\Core\Modules\MenuBuilder\Registries\MenuRegistry;
use Daylight\Core\Modules\PageBuilder\Entities\Template;
use Daylight\Core\Modules\PageBuilder\Registries\ComponentRegistry;
use Daylight\Core\Modules\PageBuilder\Registries\TemplateRegistry;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class DaylightServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        $this
            ->registerComponents()
            ->registerPageTemplates()
            ->registerNavigationMenus();
    }

    public function registerComponents(): self
    {
        ComponentRegistry::addComponents([
            new Hero,
            new ImageCTA,
            new ProductSlider,
            new CTABlocks,
            new CTA,
            new ContentImage,
            new ContentColumns,
            new HeroImage,
            new Content,
            new ImageBanner,
            new Gallery,
            new Testimonials,
            new PageHeader,
            new Breadcrumbs,
            new CustomerService,
            new TemplateContent,
        ]);

        return $this;
    }

    public function registerPageTemplates(): self
    {
        TemplateRegistry::addTemplate(
            Template::create()
                ->setKey('default')
                ->setLabel(__('Default'))
        );

        TemplateRegistry::addTemplate(
            Template::create()
                ->setKey('news')
                ->setLabel(__('News'))
        );

        TemplateRegistry::addTemplate(
            Template::create()
                ->setKey('faq')
                ->setLabel(__('FAQ'))
        );

        return $this;
    }

    public function registerNavigationMenus(): self
    {
        MenuRegistry::addMenu(
            Menu::create()
                ->setKey('primary_navigation')
                ->setViewKey('primaryNavigation')
                ->setLabel('Primary Navigation')
        );

        MenuRegistry::addMenu(
            Menu::create()
                ->setKey('secondary_navigation')
                ->setViewKey('secondaryNavigation')
                ->setLabel('Secondary Navigation')
        );

        MenuRegistry::addMenu(
            Menu::create()
                ->setKey('footer_navigation_1')
                ->setViewKey('firstFooterNavigation')
                ->setLabel('Footer Navigation 1')
        );

        MenuRegistry::addMenu(
            Menu::create()
                ->setKey('footer_navigation_2')
                ->setViewKey('secondFooterNavigation')
                ->setLabel('Footer Navigation 2')
        );

        MenuRegistry::addMenu(
            Menu::create()
                ->setKey('legal_navigation')
                ->setViewKey('legalNavigation')
                ->setLabel('Legal Navigation')
        );

        if (! app()->runningInConsole()) {
            app(MenuRegistry::class)->all()->each(function (MenuEntity $menu) {
                View::share($menu->getViewKey(), MenuRegistry::getMenuItems($menu));
            });
        }

        return $this;
    }
}
