@section('head')
    <link rel="canonical" href="{{ $localizedRoute->getCanonical()  }}"/>

    @foreach($localizedRoute->getHrefLangLinks() as $locale => $link)
        <link rel="alternate" hreflang="{{ $locale }}" href="{{ $link }}">
    @endforeach
@endsection

<x-layouts.app :title="__('Order #:order', ['order' => $order->number])" :localizedRoute="$localizedRoute">
    <x-breadcrumbs
        :pages="[
            __('Account') => translatedRoute('account.index'),
            __('Addresses') => translatedRoute('account.orders.index'),
            __('Order #:order', ['order' => $order->number]) => translatedRoute('account.orders.show', $order->uuid),
        ]"
    />

    <main class="bg-white padding">
        <div class="container">
            <div class="row">
                @include('account.navigation')

                <div class="col-12 col-lg-9">
                    <x-panel :title="__('Order #:order', ['order' => $order->number])">
                        <x-session-messages />

                        <table class="order-details" width="100%">
                            <tbody>
                            <tr>
                                <td class="label">{{ __('Date') }}</td>
                                <td>{{ $order->created_at->format('d-m-Y') }}</td>
                            </tr>
                            <tr>
                                <td class="label">{{ __('Status') }}</td>
                                <td>{{ $order->status->label() }}</td>
                            </tr>
                            <tr>
                                <td class="label">{{ __('Total') }}</td>
                                <td>{{ formatPrice($order->total) }}</td>
                            </tr>
                            </tbody>
                        </table>

                        <table class="order-rows mt-8 mb-4" width="100%">
                            <tbody>
                            @foreach($order->items as $item)
                                <tr class="order-row">
                                    <td width="80">
                                        @if($item->variant->product)
                                            <a class="product-link" href="{{ translatedRoute('products.show', $item->variant->product->slug) }}">
                                                <img class="product-thumb" src="{{ $item->variant->getFirstMedia()->getUrl('thumbnail') }}" alt="{{ $item->variant->product ? $item->variant->product->name : $item->variant->title }}">
                                            </a>
                                        @else
                                            <img class="product-thumb" src="{{ $item->variant->getFirstMedia()->getUrl('thumbnail') }}" alt="{{ $item->variant->product ? $item->variant->product->name : $item->variant->title }}">
                                        @endif
                                    </td>
                                    <td>
                                        <p class="mb-1">{{ $item->quantity }} &times; {{ $item->variant->product ? $item->variant->product->name : $item->variant->title }}</p>
                                        <p class="sku">{{ $item->variant->sku }}</p>
                                        @if($item->variant->variationName)
                                            <small>{{ $item->variant->variationName }}</small>
                                        @endif
                                    </td>
                                    <td>
                                        {{ formatPrice($item->price) }}
                                    </td>
                                    <td class="text-right">
                                        {{ formatPrice($item->quantity * $item->price) }}
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>

                        <table class="order-totals">
                            <tr>
                                <td>{{ __('Subtotal') }}</td>
                                <td align="right">{{ formatPrice($order->subtotal) }}</td>
                            </tr>
                            <tr>
                                <td>{{ __('Shipping') }}</td>
                                <td align="right">{{ formatPrice($order->shipping) }}</td>
                            </tr>
                            @foreach($order->tax_breakdown as $tax)
                                <tr>
                                    <td>{{ $tax['name'] }} ({{ floatval($tax['rate']) }}%)</td>
                                    <td align="right">{{ formatPrice($tax['amount'] / 100) }}</td>
                                </tr>
                            @endforeach
                            @if($order->transaction_fee)
                                <tr>
                                    <td>{{ __('Transaction fee') }}</td>
                                    <td align="right">{{ formatPrice($order->transaction_fee) }}</td>
                                </tr>
                            @endif
                            <tr class="total-price">
                                <td>{{ __('Total') }}</td>
                                <td align="right">{{ formatPrice($order->total) }}</td>
                            </tr>
                        </table>

                        <div class="row mt-4">
                            <div class="col-12 col-md-6">
                                <p class="mb-2"><strong>{{ __('Billing address') }}</strong></p>

                                <address>
                                    <p>{{ $order->billingAddress->name }}</p>
                                    <p>{{ $order->billingAddress->address_line_1 }}</p>
                                    @if($order->billingAddress->address_line_2)
                                        <p>{{ $order->billingAddress->address_line_2 }}</p>
                                    @endif
                                    <p>{{ $order->billingAddress->postal_code }} {{ $order->billingAddress->city }}</p>
                                    <p>{{ strtoupper($order->billingAddress->country->name) }}</p>
                                </address>

                                @if($order->billingAddress->vat_number)
                                    <div class="account__address-vat">
                                        <p>{{ $order->billingAddress->vat_number }}</p>

                                        @if($order->billingAddress->vat_number_verified_at && $order->billingAddress->country_id !== \App\Services\Countries::defaultCountry()->id)
                                            <div class="account__address-vat--verified mt-3">
                                                <img src="{{ Vite::asset('resources/images/icons/icon-check.svg') }}" alt="{{ __('VAT number verified') }}">
                                                <p>{{ __('Eligible for VAT reverse charge.') }}</p>
                                            </div>
                                        @endif
                                    </div>
                                @endif
                            </div>

                            <div class="col-12 col-md-6">
                                <p class="mb-2"><strong>{{ __('Shipping address') }}</strong></p>

                                <address>
                                    <p>{{ $order->shippingAddress->name }}</p>
                                    <p>{{ $order->shippingAddress->address_line_1 }}</p>
                                    @if($order->shippingAddress->address_line_2)
                                        <p>{{ $order->shippingAddress->address_line_2 }}</p>
                                    @endif
                                    <p>{{ $order->shippingAddress->postal_code }} {{ $order->shippingAddress->city }}</p>
                                    <p>{{ strtoupper($order->shippingAddress->country->name) }}</p>
                                </address>

                                @if($order->shippingAddress->vat_number)
                                    <div class="account__address-vat">
                                        <p>{{ $order->shippingAddress->vat_number }}</p>

                                        @if($order->shippingAddress->vat_number_verified_at && $order->shippingAddress->country_id !== \App\Services\Countries::defaultCountry()->id)
                                            <div class="account__address-vat--verified mt-3">
                                                <img src="{{ Vite::asset('resources/images/icons/icon-check.svg') }}" alt="{{ __('VAT number verified') }}">
                                                <p>{{ __('Eligible for VAT reverse charge.') }}</p>
                                            </div>
                                        @endif
                                    </div>
                                @endif

                            </div>
                        </div>

                        <div class="{{ request()->translatedRouteIs('account.orders.*') ? 'is-active' : '' }}">
                            <a class="button button--primary" href="{{ translatedRoute('account.orders.index') }}">
                                {{ __('Go back to orders') }}
                            </a>
                        </div>
                    </x-panel>
                </div>
            </div>
        </div>
    </main>
</x-layouts.app>
