@props(['block', 'lazyLoading' => false])

<section class="c-cta">
    <div class="container">
        <div class="row">
            <div class="col-12 col-md-8 offset-lg-4 col-lg-4">
                <div class="c-cta__wrapper">
                    <div class="content">
                        @isset($block->data['title'])
                            <h2 class="title">{!! $block->data['title'] !!}</h2>
                        @endif
                        @isset($block->data['content'])
                            {!! $block->data['content'] !!}
                        @endif
                        <nav class="buttons">
                            @isset($block->data['button'])
                                <a href="{{ $block->data['button']['url'] }}" class="button button--tertiary">{{ $block->data['button']['label'] }}</a>
                            @endisset
                        </nav>
                    </div>
                </div>
            </div>

            <div class="col-12 offset-lg-1 col-lg-3">
                <figure class="c-cta__employee-thumb">
                    @if($block->media->first())
                        <img src="{{ $block->media->first()->getUrl() }}" alt=""/>
                    @endif
                </figure>
            </div>
        </div>
    </div>
    <svg class="c-cta__background" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="1920" height="407" viewBox="0 0 1920 407">
        <g id="Mask_Group_3" data-name="Mask Group 3" transform="translate(0 -3921)" clip-path="url(#clip-path)">
            <g id="Group_20342" data-name="Group 20342" transform="translate(-56.853 2880.068)" opacity="0.08">
                <g id="Group_20063" data-name="Group 20063" transform="translate(0 0)">
                    <g id="Group_20062" data-name="Group 20062">
                        <g id="Group_20061" data-name="Group 20061">
                            <g id="Group_20060" data-name="Group 20060">
                                <g id="Group_20048" data-name="Group 20048">
                                    <path id="Path_47982" data-name="Path 47982" d="M753.03,1053.323l-543.273,2.534c-41.7.23-84.556.922-128.331,2.074l-22.809.691v-10.368L58.156,950.8Q57.12,726.16,78.431,564.422q17.625-133.745,55.756-228.783a199.245,199.245,0,0,1,9.676-22.809c2.074-5.3,4.378-10.368,6.913-15.437q27.993-58.06,66.584-103.217a396.825,396.825,0,0,1,67.967-64.05C340.852,88.424,409.51,58.7,490.379,40.732,564.337,24.6,650.044,15.388,748.192,13.545l1.613,351.124c-69.119,2.074-127.64,9.677-174.641,22.118-56.677,14.976-101.143,42.854-132.938,83.4-32.025,41.01-54.6,99.992-67.276,176.944-3.456,20.275-6.451,42.163-8.985,65.893l385.453-1.843Z" transform="translate(1280.676 298.528)" fill="#fff"/>
                                    <path id="Path_47983" data-name="Path 47983" d="M1055.007,0l2.534,543.274c.23,41.7.922,84.555,2.073,128.331l.691,22.809h-10.368l-97.457.461Q727.844,695.912,566.106,674.6q-133.745-17.625-228.783-55.756a199.182,199.182,0,0,1-22.809-9.676c-5.3-2.074-10.368-4.378-15.437-6.912q-58.06-27.993-103.217-66.584A396.81,396.81,0,0,1,131.81,467.7c-41.7-55.525-71.423-124.184-89.394-205.053C26.288,188.694,17.072,102.987,15.229,4.838L366.353,3.226c2.074,69.119,9.677,127.639,22.118,174.64,14.976,56.678,42.854,101.144,83.4,132.939,41.01,32.025,99.992,54.6,176.944,67.276,20.275,3.456,42.162,6.451,65.893,8.985L712.868,1.613Z" transform="translate(335.642)" fill="#fff"/>
                                    <path id="Path_47984" data-name="Path 47984" d="M31.961,750.477,29.427,207.2c-.23-41.7-.922-84.556-2.074-128.331l-.691-22.809H37.03l97.458-.461q224.636-1.037,386.374,20.275Q654.607,93.5,749.645,131.633a199.226,199.226,0,0,1,22.809,9.677c5.3,2.074,10.368,4.378,15.437,6.912q58.06,27.993,103.217,66.585a396.825,396.825,0,0,1,64.05,67.967c41.7,55.526,71.423,124.184,89.394,205.053,16.128,73.957,25.343,159.665,27.187,257.814l-351.124,1.612c-2.073-69.119-9.677-127.64-22.118-174.64-14.976-56.678-42.854-101.144-83.4-132.939-41.011-32.025-99.992-54.6-176.944-67.276-20.275-3.456-42.163-6.451-65.893-8.985L374.1,748.865Z" transform="translate(587.62 1224.388)" fill="#fff"/>
                                    <path id="Path_47985" data-name="Path 47985" d="M0,31.924,543.274,29.39c41.7-.23,84.555-.922,128.331-2.074l22.809-.691V36.993l.461,97.458q1.037,224.636-20.275,386.374Q656.975,654.57,618.844,749.608a199.188,199.188,0,0,1-9.676,22.809c-2.074,5.3-4.378,10.368-6.912,15.436q-27.993,58.06-66.584,103.218A396.821,396.821,0,0,1,467.7,955.122c-55.525,41.7-124.184,71.423-205.053,89.393-73.957,16.128-159.664,25.343-257.813,27.187L3.226,720.578c69.119-2.073,127.639-9.676,174.64-22.118,56.678-14.976,101.144-42.853,132.939-83.4,32.025-41.01,54.6-99.992,67.276-176.944,3.456-20.274,6.451-42.162,8.985-65.893L1.613,374.062Z" transform="translate(0 586.81)" fill="#fff"/>
                                </g>
                            </g>
                        </g>
                    </g>
                </g>
            </g>
        </g>
    </svg>
</section>
