@props(['block', 'lazyLoading' => false])

<section class="testimonials-slider component-border-radius component-white">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="testimonials-slider__header">
                    @isset($block->data['title'])
                        <h2 class="title">{!! $block->data['title'] !!}</h2>
                    @endif
                    <div class="total-reviews">
                        <div class="wrapper">
                            <div class="stars">
                                @for ($i = 0; $i < 5; $i++)
                                    <svg xmlns="http://www.w3.org/2000/svg" width="11.126" height="10.622">
                                        <defs>
                                            <clipPath id="a">
                                                <path d="M0 0h11.126v10.622H0z"/>
                                            </clipPath>
                                        </defs>
                                        <g clip-path="url(#a)">
                                            <path fill="#ff8126" d="m5.768 9.121 2.755 1.449a.441.441 0 0 0 .639-.464l-.526-3.068a.441.441 0 0 1 .126-.389l2.229-2.173a.44.44 0 0 0-.243-.75l-3.08-.447a.441.441 0 0 1-.332-.24L5.958.245a.441.441 0 0 0-.79 0L3.789 3.037a.439.439 0 0 1-.332.24l-3.08.447a.44.44 0 0 0-.243.75l2.229 2.174a.44.44 0 0 1 .126.389l-.526 3.068a.441.441 0 0 0 .639.464l2.756-1.448a.44.44 0 0 1 .41 0Z"/>
                                        </g>
                                    </svg>
                                @endfor
                            </div>

                            {!! __('<strong>:score</strong> out of <a href=":url">:total reviews</a>', ['score' => 9.5, 'total' => 345, 'url' => '#']) !!}
                        </div>
                        <div class="total">
                            {{ __('9.5') }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="testimonials-slider__slider">
                    <div class="slider" data-slider-testimonials>
                        <div class="swiper-wrapper">
                            @foreach ($block->testimonials as $testimonial)
                                <div class="swiper-slide">
                                    <x-cards.testimonial
                                        :testimonial="$testimonial"
                                        :key="$testimonial->id"
                                    />
                                </div>
                            @endforeach
                        </div>
                    </div>

                    <button type="button" class="swiper-button prev swiper-button-testimonials-prev"
                            aria-label="previous slide">
                        <svg role="img" aria-label="previous slide" xmlns="http://www.w3.org/2000/svg"
                             width="35" height="35" viewBox="0 0 35 35">
                            <g id="Group_20330" data-name="Group 20330" transform="translate(-840 -585)">
                                <g id="Rectangle_2003" data-name="Rectangle 2003" transform="translate(840 585)"
                                   fill="none" stroke="#FF8126" stroke-width="1">
                                    <rect width="35" height="35" rx="17.5" stroke="none"/>
                                    <rect x="0.5" y="0.5" width="34" height="34" rx="17" fill="#FF8126"/>
                                </g>
                                <g id="Group_20129" data-name="Group 20129"
                                   transform="translate(19.103 -127.086)">
                                    <path id="Path_47987" data-name="Path 47987" d="M-14369.2-5007.5h9.2"
                                          transform="translate(15202.998 5737.087)" fill="none" stroke="#FFFF"
                                          stroke-linecap="round" stroke-width="1.5"/>
                                    <path id="Path_47988" data-name="Path 47988"
                                          d="M-14359.934-5015.933l3.808,3.809-3.808,3.808"
                                          transform="translate(15199.124 5741.711)" fill="none" stroke="#FFFF"
                                          stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                </g>
                            </g>
                        </svg>
                    </button>
                    <button type="button" class="swiper-button next swiper-button-testimonials-next"
                            aria-label="next slide">
                        <svg role="img" aria-label="previous slide" xmlns="http://www.w3.org/2000/svg"
                             width="35" height="35" viewBox="0 0 35 35">
                            <g id="Group_20330" data-name="Group 20330" transform="translate(-840 -585)">
                                <g id="Rectangle_2003" data-name="Rectangle 2003" transform="translate(840 585)"
                                   fill="none" stroke="#FF8126" stroke-width="1">
                                    <rect width="35" height="35" rx="17.5" stroke="none"/>
                                    <rect x="0.5" y="0.5" width="34" height="34" rx="17" fill="#FF8126"/>
                                </g>
                                <g id="Group_20129" data-name="Group 20129"
                                   transform="translate(19.103 -127.086)">
                                    <path id="Path_47987" data-name="Path 47987" d="M-14369.2-5007.5h9.2"
                                          transform="translate(15202.998 5737.087)" fill="none" stroke="#FFFF"
                                          stroke-linecap="round" stroke-width="1.5"/>
                                    <path id="Path_47988" data-name="Path 47988"
                                          d="M-14359.934-5015.933l3.808,3.809-3.808,3.808"
                                          transform="translate(15199.124 5741.711)" fill="none" stroke="#FFFF"
                                          stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                </g>
                            </g>
                        </svg>
                    </button>
                </div>
            </div>
        </div>
    </div>
</section>
