@props(['article'])

<article class="news-card">
    @if($article->image->first())
        <figure class="news-card__thumbnail">
            <img src="{{ $article->image->first()->getUrl() }}" alt=""/>
        </figure>
    @else
        <figure class="news-card__thumbnail">
            <img src="{{ Vite::asset('resources/images/placeholders/image-cta.jpg') }}" alt=""/>
        </figure>
    @endif
    <div class="news-card__content">
        <div class="pill-category">{{ __('News') }}</div>
        <time>{{ $article->created_at->isoFormat('LL') }}</time>
        <h2 class="post-title">{{ $article->name }}</h2>

        <a href="{{ translatedRoute('news.show', $article->slug) }}" class="button--arrow">
            {{ __('Read more') }}

            <svg xmlns="http://www.w3.org/2000/svg" width="10.59" height="9.645" viewBox="0 0 10.59 9.645">
                <g transform="translate(0.75 1.06)">
                    <path d="M-14369.2-5007.5h9.09" transform="translate(14369.203 5011.262)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-width="1.5"/>
                    <path d="M-14359.936-5008.41l3.762-3.762-3.762-3.761" transform="translate(14365.264 5015.934)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                </g>
            </svg>
        </a>
    </div>

    <a href="{{ translatedRoute('news.show', $article->slug) }}" class="news-card__link"></a>
</article>
