@props(['product'])

<article class="product-card" {{ $attributes }}>
    <livewire:wishlist.add-to-wishlist
        :product="$product"
        :absolute="true"
    />

    <figure class="product-card__thumbnail">
        <a href="{{ translatedRoute('products.show', $product->slug) }}">
            @if($product->getFirstMedia())
                <picture>
                    <source type="image/webp" srcset="{{ $product->getFirstMedia()->getUrl('thumbnail-webp') }}">

                    <source type="image/jpg" srcset="
                        {{ $product->getFirstMedia()->getUrl('thumbnail-2x') }} 2x,
                        {{ $product->getFirstMedia()->getUrl('thumbnail') }}
                    ">

                    <img
                        src="{{ $product->getFirstMedia()->getUrl('thumbnail') }}"
                        srcset="
                            {{ $product->getFirstMedia()->getUrl('thumbnail-2x') }} 2x,
                            {{ $product->getFirstMedia()->getUrl('thumbnail') }}
                        "
                        alt="{{ $product->name }}"
                    >
                </picture>
            @else
                <img src="{{ Vite::asset('resources/images/placeholders/product-image.png') }}" alt="product name"/>
            @endif
        </a>
    </figure>

    <div class="product-card__content">
        @if($product->labels->isNotEmpty())
            @foreach($product->labels as $label)
                <div class="pill-category">{{ $label->name }}</div>
            @endforeach
        @endif

        <header>
            <h3 class="product-name">{{ $product->name }}</h3>
            <ul class="product-usps">
                <li>
                    <svg class="icon-checkmark" role="img" aria-label="icon checkmark" xmlns="http://www.w3.org/2000/svg" width="13.764" height="10.036" viewBox="0 0 13.764 10.036">
                        <path id="Path_47989" data-name="Path 47989" d="M3526.652-6174.925l3.855,3.854,7.789-8.226" transform="translate(-3525.592 6180.356)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                    </svg>
                    {{ __('Advice from professionals') }}
                </li>
                <li>
                    <svg class="icon-checkmark" role="img" aria-label="icon checkmark" xmlns="http://www.w3.org/2000/svg" width="13.764" height="10.036" viewBox="0 0 13.764 10.036">
                        <path id="Path_47989" data-name="Path 47989" d="M3526.652-6174.925l3.855,3.854,7.789-8.226" transform="translate(-3525.592 6180.356)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                    </svg>
                    {{ __('Shipping within 3 days') }}
                </li>
            </ul>
        </header>

        <div class="product-price">
            <span class="label-vat">{{ __('excl. VAT') }}</span>
            {{--                <span class="price in-sale">--}}
            {{--                   <del>€239,00</del>--}}
            {{--                   <ins>€199,00</ins>--}}
            {{--               </span>--}}
            <span class="price">{{ formatPrice($product->price) }}</span>
        </div>
    </div>
    <a
        class="product-card__btn-buy-product" aria-label="Add to cart"
        @if($product->variants->count() === 1)
            @click.prevent="@this.addToCart({{ $product->variants->first()->id }})"
        @endif
        href="{{ translatedRoute('products.show', $product->slug) }}"
    >
        <svg role="img" aria-label="icon shopping bag" xmlns="http://www.w3.org/2000/svg" width="14.636" height="19.642" viewBox="0 0 14.636 19.642">
            <g id="Group_20124" data-name="Group 20124" transform="translate(-1680.482 -29.25)">
                <g class="st0-1" id="Rectangle_1982" data-name="Rectangle 1982" transform="translate(1680.482 34.906)" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5">
                    <rect width="14.636" height="13.986" rx="1" stroke="none"/>
                    <rect x="0.75" y="0.75" width="13.136" height="12.486" rx="0.25" fill="none"/>
                </g>
                <g id="Group_2899" data-name="Group 2899" transform="translate(1683.306 30)">
                    <path id="Path_36083" data-name="Path 36083" d="M5.505,8.988C1.987,6.958,0,5.75,0,4.494S1.987,2.017,5.505,0" transform="translate(8.988) rotate(90)" fill="none" stroke="currentColor" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="1.5"/>
                    <path class="st0-2" id="Path_36084" data-name="Path 36084" d="M1.966,6.558C.71,5.077,0,4.2,0,3.279S.71,1.472,1.966,0" transform="translate(1.215 11.412) rotate(-90)" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="1.5"/>
                </g>
            </g>
        </svg>
    </a>
</article>
