@props([
    'name',
    'title' => '',
])

<div
    x-data="{
        isVisible: false
    }"
    x-on:close.stop="isVisible = false"
    x-on:toggle-modal.window="$event.detail == '{{ $name }}' ? isVisible = !isVisible : null"
    x-on:keydown.escape.window="isVisible = false"
    x-show="isVisible"
    x-cloak
    class="modal"
>
    <div
        class="modal__backdrop"
        x-show="isVisible"
        x-transition.opacity.delay.50ms
        x-transition.opacity.duration.300ms
    ></div>

    <div
        x-on:click.outside="isVisible = false"
        x-transition.opacity.delay.50ms
        x-transition.opacity.duration.300ms
        x-show="isVisible"
        class="modal__inner"
    >
        <button @click.prevent="isVisible = !isVisible" class="modal__close">
            <svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                <path stroke-linecap="round" stroke-linejoin="round" d="M6 18 18 6M6 6l12 12"></path>
            </svg>
        </button>

        @isset($title)
            <div class="modal__title">
                <h3>{{ $title }}</h3>
            </div>
        @endif

        {{ $slot }}

        @isset($buttons)
            <div class="modal__buttons">
                {{ $buttons }}
            </div>
        @endif
    </div>
</div>
