<div
    class="header"
    :class="{ 'header--scrolled': hasScrolled }"
    x-data="{
        hasScrolled: false
    }"
    @scroll.window.trottle="hasScrolled = window.pageYOffset > 0"
>
    <div class="container">
        <div class="header__inner">
            <div class="header__left">
                <a href="{{ translatedRoute('page') }}">
                    <img src="{{ Vite::asset('resources/images/logo.svg') }}" alt="{{ $generalSettings->name ?? config('app.name') }}"/>
                </a>

                <ul>
                    @foreach($primaryNavigation as $menuItem)
                        <li class="{{ $menuItem->children->isNotEmpty() ? 'has-megamenu' : '' }}">
                            <a href="{{ $menuItem->url }}">{{ $menuItem->name }}</a>

                            @if($menuItem->children->isNotEmpty())
                                <div class="megamenu">
                                    <div class="megamenu__inner">
                                        <div class="megamenu__column">
                                            <h3>{{ $menuItem->name }}</h3>
                                            <div class="megamenu__navigation">
                                                @foreach($menuItem->children->chunk(round($menuItem->children->count() / 2)) as $column)
                                                    <ul>
                                                        @foreach($column as $child)
                                                            <li>
                                                                <a href="{{ $child->url }}">{{ $child->name }}</a>
                                                            </li>
                                                        @endforeach
                                                    </ul>
                                                @endforeach
                                            </div>
                                        </div>
                                        <div class="megamenu__column">
                                            <h3>{{ __('Why :name', ['name' => app(\Daylight\Core\Settings\General::class)->name ?: config('app.name')]) }}</h3>
                                            @if(app(\App\Daylight\Settings\USPs::class)->usps)
                                                <div class="megamenu__usps">
                                                    <ul>
                                                        @foreach(app(\App\Daylight\Settings\USPs::class)->usps[app()->getLocale()] as $usp)
                                                            <li>{{ $usp }}</li>
                                                        @endforeach
                                                    </ul>
                                                </div>
                                            @endif
                                        </div>
                                        <a class="megamenu__column megamenu__column--cta" href="/contact/">
                                            <img src="{{ Vite::asset('resources/images/megamenu-contact.png') }}" alt="">
                                            <h3>{{ __('Are you having trouble with something?') }}</h3>
                                            <p>{{ __('We are happy to help you!') }}</p>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="10.59" height="9.645"><g fill="none" stroke="#ff8126" stroke-linecap="round" stroke-width="1.5"><path d="M.753 4.822h9.09"/><path stroke-linejoin="round" d="M6.078 8.584 9.84 4.822 6.078 1.061"/></g></svg>
                                        </a>
                                    </div>
                                </div>
                            @endif
                        </li>
                    @endforeach
                </ul>
            </div>

            <div class="header__right">
                <form action="{{ translatedRoute('products.index') }}" class="header__search">
                    <input type="text"
                           value="{{ request()->get('q') }}"
                           placeholder="{{ __('What are you looking for?') }}"
                           @click.prevent="$dispatch('toggle-slide-over', 'search')"
                           x-data
                    >
                </form>

                <a class="header__cta" href="{{ translatedRoute('page', 'contact') }}">
                    <img src="{{ Vite::asset('resources/images/header-cta.png') }}" alt="{{ __('Contact') }}">
                    {{ __('Contact') }}
                </a>

                <ul class="header__icons">
                    <li class="header__search-icon">
                        <button @click.prevent="$dispatch('toggle-slide-over', 'search')" x-data>
                            <img src="{{ Vite::asset('resources/images/icons/icon-search.svg') }}" alt="{{ __('Search') }}">
                        </button>
                    </li>
                    <li class="header__account has-submenu">
                        <a href="{{ translatedRoute(auth()->check() ? 'account.index' : 'login') }}">
                            <img src="{{ Vite::asset('resources/images/icons/icon-user.svg') }}" alt="{{ __('User menu') }}">
                        </a>

                        <ul>
                            @auth
                                <li><a href="{{ translatedRoute('account.index') }}">{{ __('My account') }}</a></li>
                                <li><a href="{{ translatedRoute('account.password') }}">{{ __('Password') }}</a></li>
                                <li><a href="{{ translatedRoute('account.addresses.index') }}">{{ __('Addresses') }}</a></li>
                                <li><a href="{{ translatedRoute('account.orders.index') }}">{{ __('Orders') }}</a></li>
                                <li>
                                    <form method="POST" action="{{ translatedRoute('logout') }}" style="display: none;" id="logout">
                                        @csrf
                                    </form>

                                    <a href="{{ translatedRoute('logout') }}" onclick="event.preventDefault(); document.getElementById('logout').submit();">
                                        {{ __('Sign out') }}
                                    </a>
                                </li>

                                @if(auth()->check() && auth()->user()->can('view:administration'))
                                    <li class="border-top">
                                        <a href="{{ route('daylight.index') }}">
                                            {{ __('Admin dashboard') }}
                                        </a>
                                    </li>
                                @endif
                            @else
                                <li><a href="{{ translatedRoute('login') }}">{{ __('Login') }}</a></li>
                                <li><a href="{{ translatedRoute('register') }}">{{ __('Register') }}</a></li>
                            @endif
                        </ul>
                    </li>
                    <li class="header__wishlist">
                        <livewire:wishlist.button />
                    </li>
                    <li class="header__cart">
                       <livewire:cart.button />
                    </li>
                    <li class="header__offcanvas">
                        <button @click.prevent="$dispatch('toggle-slide-over', 'mobile-menu')" x-data>
                            <img src="{{ Vite::asset('resources/images/icons/icon-navigation.svg') }}" alt="{{ __('Open menu') }}">
                        </button>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>
