<x-slide-over name="mobile-menu">
    <x-slot:header>
        <div class="slide-over__header slide-over__header--gray">
            <div class="container">
                <div class="slide-over__header-inner">
                    <div class="slide-over__left">
                        <a href="{{ translatedRoute('page') }}">
                            <img src="{{ Vite::asset('resources/images/logo.svg') }}" alt="{{ $generalSettings->name ?? config('app.name') }}"/>
                        </a>
                    </div>

                    <div class="slide-over__right">
                        <ul class="slide-over__icons">
                            <li class="slide-over__search-icon">
                                <a href="#">
                                    <img src="{{ Vite::asset('resources/images/icons/icon-search.svg') }}" alt="">
                                </a>
                            </li>
                            <li class="slide-over__account">
                                <a href="#">
                                    <img src="{{ Vite::asset('resources/images/icons/icon-user.svg') }}" alt="">
                                </a>
                            </li>
                            <li class="slide-over__cart">
                                <button @click.prevent="$dispatch('toggle-slide-over', 'cart-drawer')" x-data>
                                    <span class="badge">0</span>
                                    <img src="{{ Vite::asset('resources/images/icons/icon-cart.svg') }}" alt="{{ __('Cart') }}">
                                </button>
                            </li>
                            <li class="slide-over__offcanvas">
                                <button @click.prevent="isVisible = !isVisible">
                                    <img src="{{ Vite::asset('resources/images/icons/icon-close.svg') }}" alt="{{ __('Close') }}">
                                </button>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </x-slot:header>

    <div class="offcanvas">
        <div class="offcanvas__header">
            <ul class="offcanvas__actions">
                <li>
                    <livewire:wishlist.button />
                </li>

                @if($localizedRoute && config('multilingualism.show_locale_selector') && \Daylight\Core\Modules\Multilingualism\Multilingualism::getAvailableLocales()->count() > 1)
                    <li>
                        <button>
                            <img src="{{ Vite::asset('resources/images/flags/'.app()->getLocale().'.svg') }}" alt="{{ app()->getLocale() }}" class="flag">
                        </button>

                        <ul>
                            @foreach($localizedRoute->getHrefLangLinks(false) as $locale => $url)
                                <li>
                                    <a href="{{ $url }}">
                                        <img src="{{ daylightAsset('resources/assets/images/flags/'.strtolower($locale).'.svg') }}" alt="{{ $locale }}" class="flag">
                                        {{ strtoupper($locale) }}
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </li>
                @endif
            </ul>

            <a href="{{ translatedRoute('page', 'contact') }}" class="offcanvas__cta">
                <img src="{{ Vite::asset('resources/images/header-cta.png') }}" alt="{{ __('Contact') }}">
                {{ __('Contact') }}
            </a>
        </div>

        @if($primaryNavigation)
            <div class="offcanvas__navigation">
                <ul>
                    @foreach($primaryNavigation as $item)
                        <li class="{{ $item->children->count() ? 'has-children' : '' }}" x-data="{ isOpen: false }" :class="{ 'is-active': isOpen }">
                            <a href="{{ $item->url }}" {!! $item->children->count() ? '@click.prevent="isOpen = !isOpen"' : '' !!}>
                                {{ $item->name }}
                            </a>

                            @if($item->children->count())
                                <ul>
                                    @foreach($item->children as $child)
                                        <li>
                                            <a href="{{ $child->url }}">
                                                {{ $child->name }}
                                            </a>
                                        </li>
                                    @endforeach
                                </ul>
                            @endif
                        </li>
                    @endforeach
                </ul>
            </div>
        @endif
    </div>
</x-slide-over>
