@extends('daylight::layouts.app')

@section('title', __('USP\'s'))

@section('content')
    <x-daylight::page-header :title="__('USP\'s')"/>

    <x-daylight::session-messages/>

    <form method="post" action="{{ route('daylight.settings.usps.update') }}">
        @csrf
        @method('PUT')

        <x-daylight::input.group
            for="usps"
            :label="__('USP\'s')"
            :error="$errors->first('usps')"
            :required="true"
        >
            <div class="grid grid-cols-2 gap-4 mb-2">
                @foreach(\Daylight\Core\Modules\Multilingualism\Multilingualism::getAvailableLocales() as $locale)
                    <div class="text-sm text-gray-600">{{ strtoupper($locale) }}</div>
                @endforeach
            </div>

            <div class="grid grid-cols-2 gap-4">
                @foreach(\Daylight\Core\Modules\Multilingualism\Multilingualism::getAvailableLocales() as $locale)
                    <div class="gap-4 grid">
                        @for($i = 0; $i <= 3; $i++)
                            <x-daylight::input.text
                                name="usps[{{$locale}}][{{ $i }}]"
                                id="usps_{{$locale}}_{{$i}}"
                                value="{{ old('usps.'.$locale.'.'.$i, $settings->usps[$locale][$i]) }}"
                                :disabled="!auth()->user()->can('update:settings')"
                            />
                        @endfor
                    </div>

                @endforeach
            </div>

        </x-daylight::input.group>

        @can('update:settings')
            <div class="mt-6 flex items-center justify-end gap-x-3">
                <x-daylight::buttons.primary type="submit">
                    {{ __('Save') }}
                </x-daylight::buttons.primary>
            </div>
        @endcan
    </form>
@endsection
