<main class="padding bg-white component-border-radius">
    <div class="container">
        <div class="row">
            <div class="col-12 col-lg-8">
                <x-panel class="cart">
                    <div class="cart__header">
                        <h2>{{ __('Products') }} <span class="badge">{{ $this->cart()->count() }}</span></h2>
                    </div>

                    @if($this->cart()->isEmpty())
                        <div class="cart-drawer__empty">
                            {{ __('Your cart is currently empty.') }}
                        </div>
                    @else
                        @foreach($cartItems as $index => $item)
                            <div class="cart-drawer__row cart-item" wire:loading.delay.class="is-loading"
                                 wire:target="quantity, remove" wire:key="cart-drawer-item-{{ $item['id'] }}">
                                <div class="cart-item__left">
                                    <div class="cart-item__image">
                                        <a href="{{ $item['url'] }}">
                                            <img src="{{ $item['image'] }}" alt="{{ $item['name'] }}">
                                        </a>
                                    </div>

                                    <div class="cart-item__details">
                                        <div>
                                            <h4>{{ $item['name'] }}</h4>
                                            <p>{{ !empty($item['variantName']) ? $item['variantName'] : $item['sku'] }}</p>
                                        </div>

                                        <div class="quantity"
                                             x-data="{ quantity: @entangle('cartItems.'. $index . '.quantity') }">
                                            <button class="quantity__decrement"
                                                    @click.prevent="(quantity = quantity > 1 ? quantity-1 : 1); $refs['quantity-{{ $index }}'].dispatchEvent(new Event('change'))">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="8" height="1.2"
                                                     viewBox="0 0 8 1.2">
                                                    <path id="Path_8960" data-name="Path 8960" d="M-8881.847-5930.119h8"
                                                          transform="translate(8881.847 5930.719)" fill="none"
                                                          stroke="#171716" stroke-width="1.2"/>
                                                </svg>
                                            </button>

                                            <x-input.text
                                                wire:model="cartItems.{{ $index }}.quantity"
                                                wire:change.debounce="updateQuantity({{ $item['id'] }}, $event.target.value)"
                                                id="quantity-{{ $index }}"
                                                x-ref="quantity-{{ $index }}"
                                                type="number"
                                                min="1"
                                                class="quantity__input"
                                            />

                                            <button class="quantity__increment"
                                                    @click.prevent="quantity++; $refs['quantity-{{ $index }}'].dispatchEvent(new Event('change'))">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="8" height="8"
                                                     viewBox="0 0 8 8">
                                                    <g id="Group_18870" data-name="Group 18870"
                                                       transform="translate(-1467 -259)">
                                                        <path id="Path_8960" data-name="Path 8960"
                                                              d="M-8881.847-5930.119h8"
                                                              transform="translate(10348.847 6193.119)" fill="none"
                                                              stroke="#171716" stroke-width="1.2"/>
                                                        <path id="Path_36621" data-name="Path 36621"
                                                              d="M-8881.847-5930.119h8"
                                                              transform="translate(7401.119 -8614.847) rotate(-90)"
                                                              fill="none" stroke="#171716" stroke-width="1.2"/>
                                                    </g>
                                                </svg>
                                            </button>
                                        </div>
                                    </div>
                                </div>

                                <div class="cart-item__right">
                                    <div class="cart-item__price">
                                        <p class="price">{{ formatPrice($item['quantity'] * $item['price']) }}</p>
                                    </div>


                                    <div class="cart-item__delete">
                                        <button
                                            @click='dataLayer.push({event: "remove_from_cart", ecommerce: { items: [@json($item['dataLayer'])] }});'
                                            wire:click.prevent="deleteItem('{{ $item['id'] }}')">
                                            <svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor"
                                                 viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"
                                                 aria-hidden="true">
                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                      d="m14.74 9-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 0 1-2.244 2.077H8.084a2.25 2.25 0 0 1-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 0 0-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 0 1 3.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 0 0-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 0 0-7.5 0"></path>
                                            </svg>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @endif
                </x-panel>

                <x-panel class="cart">
                    <div class="cart__header">
                        <h2>{{ __('Related products') }}</h2>
                    </div>

                    <p>@todo: implement cross sells</p>
                </x-panel>
            </div>

            <div class="col-12 col-lg-4">
                <x-panel class="cart__summary">
                    <dl>
                        <div>
                            <dt>{{ __('Subtotal') }}</dt>
                            <dd class="cart__value">{{ formatPrice($this->subtotal()) }}</dd>
                        </div>

                        @foreach($this->taxes() as $tax)
                            <div>
                                <dt>{{ $tax['name'] }} ({{ round($tax['rate']) }}%)</dt>
                                <dd class="cart__value">{{ formatPrice($tax['amount']) }}</dd>
                            </div>
                        @endforeach

                        <div>
                            <dt>{{ __('Total') }}</dt>
                            <dd class="cart__value">{{ formatPrice($this->total()) }}</dd>
                        </div>
                    </dl>

                    <div class="cart__buttons">
                        <a href="{{ translatedRoute('checkout.index') }}"
                           class="button button--primary button--full-width">
                            {{ __('Checkout') }}
                        </a>
                        <a href="#" class="button button--secondary button--full-width">{{ __('Request quote') }}</a>
                    </div>

                    <x-contact-cta :small="true" />
                </x-panel>
            </div>
        </div>
    </div>

    <script>
        dataLayer.push({ecommerce: null});
        dataLayer.push({event: 'view_cart', ecommerce: {items: @json($dataLayerProducts) }});
    </script>
</main>
