<main
    class="padding bg-white component-border-radius"
    x-data="{
                init() {
                    Livewire.hook('commit', ({ succeed }) => {
                        succeed(() => {
                            this.$nextTick(() => {
                                const firstErrorMessage = document.querySelector('.has-error')

                                if (firstErrorMessage !== null) {
                                    firstErrorMessage.scrollIntoView({ block: 'center', inline: 'center' })
                                }
                            })
                        })
                    })
                }
            }"
>
    <form action="{{ translatedRoute('checkout.index') }}" method="post" wire:submit.prevent="submit"
          x-data="{ customerType: $wire.entangle('form.accountDetails.type') }">
        @csrf

        <div class="container">
            <div class="row">
                <div class="col-12 col-lg-8">
                    <!-- Errors -->
                    @if ($errors->any())
                        <div class="alert alert--error">
                            <p>{{ __('There were some errors processing your request.') }}</p>
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <x-panel :title="__('Details')">
                        @guest
                            <x-input.group
                                for="email"
                                :label="__('Email address')"
                                :error="$errors->first('form.accountDetails.email')"
                            >
                                <x-slot:helpText>
                                    {!! __('Do you already have a account? <a href=":url">Sign in</a>', ['url' => translatedRoute('login', ['intended' => translatedRoute('checkout.index')])]) !!}
                                </x-slot:helpText>

                                <x-input.text
                                    id="email"
                                    type="email"
                                    wire:model.blur="form.accountDetails.email"
                                    :placeholder="__('name@example.com')"
                                />
                            </x-input.group>
                        @endguest

                        <div
                            x-data="{ copyBillingAddress: $wire.entangle('form.copyShippingAddressFromBilling').live }">
                            @guest
                                <x-input.group
                                    for="type"
                                    :label="__('Type')"
                                    :error="$errors->first('form.accountDetails.type')"
                                >
                                    <x-input.select id="type" wire:model="form.accountDetails.type">
                                        <option value="individual">{{ __('Individual') }}</option>
                                        <option value="business">{{ __('Business') }}</option>
                                    </x-input.select>
                                </x-input.group>
                            @endguest

                            <div class="row">
                                <div class="col-12 col-md-6">
                                    <x-input.group
                                        for="name"
                                        :label="__('Name')"
                                        :error="$errors->first('form.accountDetails.name')"
                                    >
                                        <x-input.text
                                            id="name"
                                            wire:model="form.accountDetails.name"
                                            :placeholder="__('John')"
                                        />
                                    </x-input.group>
                                </div>

                                <div class="col-12 col-md-6">
                                    <x-input.group
                                        for="last_name"
                                        :label="__('Last name')"
                                        :error="$errors->first('form.accountDetails.last_name')"
                                    >
                                        <x-input.text
                                            id="last_name"
                                            wire:model="form.accountDetails.last_name"
                                            :placeholder="__('Doe')"
                                        />
                                    </x-input.group>
                                </div>
                            </div>

                            <x-input.group
                                for="phone"
                                :label="__('Phone')"
                                :error="$errors->first('form.accountDetails.phone')"
                            >
                                <x-input.text
                                    id="phone"
                                    wire:model="form.accountDetails.phone"
                                    :placeholder="__('+31 6 12345678')"
                                />
                            </x-input.group>

                            @if(auth()->check() && $this->billingAddresses()->isNotEmpty())
                                <x-input.group
                                    for="type"
                                    :label="__('Pre-saved address')"
                                    :error="$errors->first('form.billingAddressId')"
                                >
                                    <x-input.select id="type" wire:model.live="billingAddressId">
                                        <option value="">{{ __('Manually enter address') }}</option>
                                        @foreach($this->billingAddresses() as $address)
                                            <option value="{{ $address->id }}">{{ $address->name }}</option>
                                        @endforeach
                                    </x-input.select>
                                </x-input.group>
                            @endif

                            @if($billingAddressId)
                                <address class="checkout__address">
                                    <strong>{{ $this->form->billingAddress['name'] }}</strong>
                                    <p>{{ $this->form->billingAddress['address_line_1'] }}</p>

                                    @if($this->form->billingAddress['address_line_2'])
                                        <p>{{ $this->form->billingAddress['address_line_2'] }}</p>
                                    @endif

                                    <p>{{ $this->form->billingAddress['postal_code'] }} {{ $this->form->billingAddress['city'] }}</p>
                                    <p>{{ $countries->firstWhere('id', $this->form->billingAddress['country_id'])?->name }}</p>

                                    @if($this->form->billingAddress['vat_number'])
                                        <div class="checkout__vat">
                                            <p>{{ $this->form->billingAddress['vat_number'] }}</p>

                                            @if($this->form->billingAddress['vat_number_verified_at'] && $this->form->billingAddress['country_id'] !== \App\Services\Countries::defaultCountry()->id)
                                                <div class="checkout__vat-verified">
                                                    <img
                                                        src="{{ Vite::asset('resources/images/icons/icon-check.svg') }}"
                                                        alt="{{ __('VAT number verified') }}">
                                                    <p>{{ __('This VAT number has been checked and is eligible for VAT reverse charge.') }}</p>
                                                </div>
                                            @endif
                                        </div>
                                    @endif
                                </address>
                            @else
                                <div x-show="customerType === 'business'" x-cloak>
                                    <x-input.group
                                        for="company_name"
                                        :label="__('Company name')"
                                        :error="$errors->first('form.billingAddress.name')"
                                    >
                                        <x-input.text
                                            id="company_name"
                                            wire:model="form.billingAddress.name"
                                            :placeholder="__('Acme Inc.')"
                                        />
                                    </x-input.group>

                                    <x-input.group
                                        class="input-group--vat"
                                        for="vat_number"
                                        :label="__('VAT number')"
                                        :error="$errors->first('form.billingAddress.vat_number')"
                                    >
                                        <x-slot:helpText>
                                            {{ __('Fill in your VAT number to apply reverse charge.') }}
                                        </x-slot:helpText>

                                        <div class="vat-input__wrapper">
                                            <x-input.text
                                                id="vat_number"
                                                wire:model.blur="form.billingAddress.vat_number"
                                                placeholder="{{ __('DE00000000') }}"
                                            />

                                            @if($this->form->billingAddress['vat_number_verified_at'] && $this->form->billingAddress['country_id'] !== \App\Services\Countries::defaultCountry()->id)
                                                <div class="vat-input__status">
                                                    <img
                                                        src="{{ Vite::asset('resources/images/icons/icon-check.svg') }}"
                                                        alt="{{ __('VAT number verified') }}">
                                                </div>
                                            @endif

                                            <div class="vat-input__loader" wire:loading
                                                 wire:target="form.billingAddress.vat_number">
                                                <img src="{{ Vite::asset('resources/images/icons/icon-loader.svg') }}"
                                                     alt="{{ __('Loading..') }}" width="24" height="24">
                                            </div>

                                            @if($this->form->billingAddress['vat_number_verified_at'] && $this->form->billingAddress['country_id'] !== \App\Services\Countries::defaultCountry()->id)
                                                <p class="input-group__success">{{ __('This VAT number has been checked and is eligible for VAT reverse charge.') }}</p>
                                            @endif
                                        </div>
                                    </x-input.group>
                                </div>

                                <x-input.group
                                    for="billing_address_line_1"
                                    :label="__('Address line 1')"
                                    :error="$errors->first('form.billingAddress.address_line_1')"
                                >
                                    <x-input.text
                                        id="billing_address_line_1"
                                        wire:model="form.billingAddress.address_line_1"
                                        placeholder="{{ __('Main Street 12') }}"
                                    />
                                </x-input.group>

                                <x-input.group
                                    for="billing_address_line_2"
                                    :label="__('Address line 2')"
                                    :error="$errors->first('form.billingAddress.address_line_2')"
                                >
                                    <x-input.text
                                        id="billing_address_line_2"
                                        wire:model="form.billingAddress.address_line_2"
                                        :placeholder="__('Apartment, suite, PO-box, etc.')"
                                    />
                                </x-input.group>

                                <div class="row">
                                    <div class="col-6">
                                        <x-input.group
                                            for="billing_postal_code"
                                            :label="__('Postal code')"
                                            :error="$errors->first('form.billingAddress.postal_code')"
                                        >
                                            <x-input.text
                                                id="billing_postal_code"
                                                wire:model="form.billingAddress.postal_code"
                                                placeholder="{{ __('1234 AB') }}"
                                            />
                                        </x-input.group>
                                    </div>

                                    <div class="col-6">
                                        <x-input.group
                                            for="billing_city"
                                            :label="__('City')"
                                            :error="$errors->first('form.billingAddress.city')"
                                        >
                                            <x-input.text
                                                id="billing_city"
                                                wire:model="form.billingAddress.city"
                                                placeholder="Amsterdam"
                                            />
                                        </x-input.group>
                                    </div>
                                </div>

                                <x-input.group
                                    for="billing_country"
                                    :label="__('Country')"
                                    :error="$errors->first('form.billingAddress.country_id')"
                                >
                                    <x-input.select id="billing_country"
                                                    wire:model.live="form.billingAddress.country_id">
                                        @foreach($countries as $country)
                                            <option value="{{ $country->id }}">{{ $country->name }}</option>
                                        @endforeach
                                    </x-input.select>
                                </x-input.group>
                            @endif

                            <hr>

                            <h3>{{ __('Shipping') }}</h3>

                            <div class="mb-4">
                                <div class="checkout__checkboxes mb-4">
                                    <label class="radio-group">
                                        <input type="radio" x-model="copyBillingAddress" value="1">
                                        <span>{{ __('Use the same address for shipping') }}</span>
                                    </label>

                                    <label class="radio-group">
                                        <input type="radio" x-model="copyBillingAddress" value="0">
                                        <span>{{ __('Use a different address') }}</span>
                                    </label>
                                </div>

                                <div x-show="!copyBillingAddress" x-cloak>
                                    @if(auth()->check() && $this->shippingAddresses()->isNotEmpty())
                                        <x-input.group
                                            for="shipping_address_id"
                                            :label="__('Pre-saved address')"
                                            :error="$errors->first('form.shippingAddressId')"
                                        >
                                            <x-input.select id="shipping_address_id"
                                                            wire:model.live="shippingAddressId">
                                                <option value="">{{ __('Manually enter address') }}</option>
                                                @foreach($this->shippingAddresses() as $address)
                                                    <option value="{{ $address->id }}">{{ $address->name }}</option>
                                                @endforeach
                                            </x-input.select>
                                        </x-input.group>
                                    @endif

                                    @if($shippingAddressId)
                                        <address class="checkout__address">
                                            <strong>{{ $this->form->shippingAddress['name'] }}</strong>
                                            <p>{{ $this->form->shippingAddress['address_line_1'] }}</p>

                                            @if($this->form->shippingAddress['address_line_2'])
                                                <p>{{ $this->form->shippingAddress['address_line_2'] }}</p>
                                            @endif

                                            <p>{{ $this->form->shippingAddress['postal_code'] }} {{ $this->form->shippingAddress['city'] }}</p>
                                            <p>{{ $countries->firstWhere('id', $this->form->shippingAddress['country_id'])?->name }}</p>
                                        </address>
                                    @else
                                        <x-input.group
                                            for="shipping_name"
                                            :label="__('Name')"
                                            :error="$errors->first('form.shippingAddress.name')"
                                        >
                                            <x-input.text
                                                id="shipping_name"
                                                wire:model="form.shippingAddress.name"
                                                :placeholder="__('Acme Inc.')"
                                            />
                                        </x-input.group>

                                        <x-input.group
                                            for="shipping_address_line_1"
                                            :label="__('Address line 1')"
                                            :error="$errors->first('form.shippingAddress.address_line_1')"
                                        >
                                            <x-input.text
                                                id="shipping_address_line_1"
                                                wire:model="form.shippingAddress.address_line_1"
                                                :placeholder="__('Streetname 12')"
                                            />
                                        </x-input.group>

                                        <x-input.group
                                            for="shipping_address_line_2"
                                            :label="__('Address line 2')"
                                            :error="$errors->first('form.shippingAddress.address_line_2')"
                                        >
                                            <x-input.text
                                                id="shipping_address_line_2"
                                                wire:model="form.shippingAddress.address_line_2"
                                                :placeholder="__('Apartment, suite, PO-box, etc.')"
                                            />
                                        </x-input.group>

                                        <div class="row">
                                            <div class="col-6">
                                                <x-input.group
                                                    for="shipping_postal_code"
                                                    :label="__('Postal code')"
                                                    :error="$errors->first('form.shippingAddress.postal_code')"
                                                >
                                                    <x-input.text
                                                        id="shipping_postal_code"
                                                        wire:model="form.shippingAddress.postal_code"
                                                        placeholder="1234 AB"
                                                    />
                                                </x-input.group>
                                            </div>

                                            <div class="col-6">
                                                <x-input.group
                                                    for="shipping_city"
                                                    :label="__('City')"
                                                    :error="$errors->first('form.shippingAddress.city')"
                                                >
                                                    <x-input.text
                                                        id="shipping_city"
                                                        wire:model="form.shippingAddress.city"
                                                        placeholder="Amsterdam"
                                                    />
                                                </x-input.group>
                                            </div>
                                        </div>

                                        <x-input.group
                                            for="shipping_country"
                                            :label="__('Country')"
                                            :error="$errors->first('form.shippingAddress.country_id')"
                                        >
                                            <x-input.select id="shipping_country"
                                                            wire:model.live="form.shippingAddress.country_id">
                                                @foreach($countries as $country)
                                                    <option value="{{ $country->id }}">{{ $country->name }}</option>
                                                @endforeach
                                            </x-input.select>
                                        </x-input.group>
                                    @endif
                                </div>
                            </div>

                        </div>

                        <hr>

                        <h3>{{ __('Order notes') }}</h3>

                        <x-input.group
                            for="notes"
                            :label="__('Notes')"
                            :error="$errors->first('form.notes')"
                        >
                            <x-input.textarea
                                id="notes"
                                wire:model="form.notes"
                            />
                        </x-input.group>

                        <div class="mt-4">
                            <div class="checkout__checkboxes">
                                <label class="checkbox-group">
                                    <input type="checkbox" name="terms" value="1" wire:model.live="form.terms" required>
                                    <span>{{ __('I agree with the terms & conditions.') }}</span>
                                </label>

                                @error('form.terms')
                                <p class="error">{{ $message }}</p>
                                @enderror

                                <label class="checkbox-group">
                                    <input type="checkbox" name="privacy" value="1" wire:model.live="form.privacy"
                                           required>
                                    <span>{{ __('I agree to the processing of my data in accordance with the privacy policy.') }}</span>
                                </label>

                                @error('form.privacy')
                                <p class="error">{{ $message }}</p>
                                @enderror
                            </div>

                        </div>

                    </x-panel>

                    <x-panel :title="__('Shipping')">
                        <x-input.group
                            for="shipping_method"
                            :label="__('Shipping method')"
                            :error="$errors->first('form.shippingAddress.country_id')"
                        >
                            <div class="checkout__shipping">
                                <label class="radio-group">
                                    <input type="radio" wire:model.live="form.shippingMethod" value="shipping">
                                    <div class="radio-group--spaced">
                                        <p class="mb-0">{{ __('Shipping') }}</p>
                                        <p class="mb-0"">{{ formatPrice($this->shippingCosts(true)/100) }}</p>
                                    </div>
                                </label>

                                <label class="radio-group">
                                    <input type="radio" wire:model.live="form.shippingMethod" value="pickup">
                                    <div class="radio-group--spaced">
                                        <div>
                                            <p class="mb-0">{{ __('Pick-up at :name', ['name' => app(\Daylight\Core\Settings\General::class)->name]) }}</p>
                                        </div>
                                        <p class="mb-0">{{ __('Free') }}</p>
                                    </div>
                                </label>
                            </div>
                        </x-input.group>
                    </x-panel>

                    <x-panel :title="__('Payment')">
                        <x-input.group
                            for="payment_method"
                            :label="__('Payment method')"
                            :error="$errors->first('form.paymentMethod')"
                        >
                            <div class="checkout__shipping">
                                <label class="radio-group">
                                    <input type="radio" wire:model.live="form.paymentMethod" value="invoice">
                                    <div class="radio-group--spaced">
                                        <p>
                                            {{ __('Invoice') }}
                                        </p>
                                    </div>
                                </label>

                                @foreach($this->paymentMethods as $paymentMethod)
                                    <label class="radio-group">
                                        <input type="radio" wire:model.live="form.paymentMethod"
                                               value="{{ $paymentMethod->getId() }}">
                                        <div class="radio-group--spaced">
                                            <p>
                                                {{ $paymentMethod->getName() }}

                                                @if($paymentMethod->transactionFee() > 0)
                                                    <span>(+{{ $paymentMethod->transactionFee() }}%)</span>
                                                @endif
                                            </p>

                                            @if($paymentMethod->getIcon())
                                                <img src="{{ $paymentMethod->getIcon() }}"
                                                     alt="{{ $paymentMethod->getName() }}">
                                            @endif
                                        </div>
                                    </label>
                                @endforeach
                            </div>
                        </x-input.group>
                    </x-panel>
                </div>

                <div class="col-12 col-lg-4">
                    <x-panel class="cart-summary">
                        <div class="cart-summary__header">
                            <h2>{{ __('Products') }} <span class="badge">{{ $this->cart()->count() }}</span></h2>
                        </div>

                        @foreach($cartItems as $index => $item)
                            <div class="cart-item" wire:loading.delay.class="is-loading" wire:target="quantity, remove"
                                 wire:key="cart-drawer-item-{{ $item['id'] }}">
                                <div class="cart-item__left">
                                    <div class="cart-item__image">
                                        <a href="{{ $item['url'] }}">
                                            <img src="{{ $item['image'] }}" alt="{{ $item['name'] }}">
                                        </a>
                                    </div>

                                    <div class="cart-item__details justify-content-center">
                                        <div>
                                            <h4>{{ $item['name'] }}</h4>
                                            <p>{{ !empty($item['variantName']) ? $item['variantName'] : $item['sku'] }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="cart-item__right">
                                    <div class="cart-item__price">
                                        <p class="price">{{ formatPrice($item['quantity'] * $item['price']) }}</p>
                                    </div>
                                </div>
                            </div>
                        @endforeach

                        <dl class="cart-summary__summary">
                            <div>
                                <dt>{{ __('Subtotal') }}</dt>
                                <dd class="cart-summary__value">{{ formatPrice($this->cart()->formattedSubtotal()) }}</dd>
                            </div>

                            @if($this->shippingCosts())
                                <div>
                                    <dt>{{ __('Shipping') }}</dt>
                                    <dd class="cart-summary__value">{{ formatPrice($this->formattedShippingCosts()) }}</dd>
                                </div>
                            @else
                                <div>
                                    <dt>{{ __('Pickup') }}</dt>
                                    <dd class="cart-summary__value">{{ __('Free') }}</dd>
                                </div>
                            @endif

                            @foreach($this->taxes() as $key => $tax)
                                <div :key="{{ $key }}">
                                    <dt>{{ $tax['name'] }} ({{ floatval($tax['rate']) }}%)</dt>
                                    <dd class="cart-summary__value">{{ formatPrice($tax['amount'] / 100) }}</dd>
                                </div>
                            @endforeach

                            <div>
                                <dt>{{ __('Total') }}</dt>
                                <dd class="cart-summary__value">{{ formatPrice($this->formattedTotals()) }}</dd>
                            </div>
                        </dl>

                        <div class="cart-summary__buttons">
                            <button type="submit" class="button button--primary button--full-width mb-2" wire:loading.disabled>
                                {{ __('Proceed to payment') }}
                            </button>

                            <a href="#" class="button button--secondary button--full-width">{{ __('Request quote') }}</a>
                        </div>

                        <x-contact-cta :small="true" />
                    </x-panel>
                </div>
            </div>
        </div>
    </form>

    <script>
        dataLayer.push({ecommerce: null});
        dataLayer.push({event: 'begin_checkout', ecommerce: {items: @json($dataLayerProducts) }});
    </script>
</main>
