<div>
    @if($status === \Daylight\Core\Models\Enums\OrderStatus::PENDING)
        <x-page-header :title="__('Processing payment')">
            <p>{{ __('We\'re currently processing your payment. This page will be updated automatically.') }}</p>
        </x-page-header>
    @elseif($status === \Daylight\Core\Models\Enums\OrderStatus::AWAITING_PAYMENT)
        <x-page-header :title="__('Order placed')">
            {{ __('Your order was placed successfully. Our specialists will start packing your order as soon as possible.') }}
        </x-page-header>
    @elseif($status === \Daylight\Core\Models\Enums\OrderStatus::PROCESSING)
        <x-page-header :title="__('Order succeeded')">
            {{ __('Your payment was received successfully. Our specialists will start packing your order as soon as possible.') }}
        </x-page-header>
    @elseif($status === \Daylight\Core\Models\Enums\OrderStatus::FAILED)
        <x-page-header :title="__('Payment failed')">
            {{ __('Your payment was cancelled or something went wrong. If you think something went wrong, please contact us.') }}
        </x-page-header>
    @elseif($status === \Daylight\Core\Models\Enums\OrderStatus::CANCELLED)
        <x-page-header :title="__('Order cancelled')">
           {{ __('This order was cancelled due an incomplete payment.') }}
        </x-page-header>
    @endif

    <main class="padding bg-white component-border-radius">
        <div class="container">
            <div class="row">
                <div class="col-12 col-lg-8">
                    <x-panel :title="__('Order details')">
                        @if($status === \Daylight\Core\Models\Enums\OrderStatus::PENDING)
                            <p>{{ __('We\'re currently processing your payment. This page will be updated automatically.') }}</p>
                        @elseif($status === \Daylight\Core\Models\Enums\OrderStatus::AWAITING_PAYMENT)
                            <p>{{ __('Your order was placed successfully. Our specialists will start packing your order as soon as possible.') }}</p>
                        @elseif($status === \Daylight\Core\Models\Enums\OrderStatus::PROCESSING)
                            <p>{{ __('Your payment was received successfully. Our specialists will start packing your order as soon as possible.') }}</p>
                        @elseif($status === \Daylight\Core\Models\Enums\OrderStatus::FAILED)
                            <p>{{ __('Your payment was cancelled or something went wrong. If you think something went wrong, please contact us.') }}</p>
                        @elseif($status === \Daylight\Core\Models\Enums\OrderStatus::CANCELLED)
                            <p>{{ __('This order was cancelled due an incomplete payment.') }}</p>
                        @endif

                        <div class="row">
                            <div class="col-12 col-md-6">
                                <div class="order-overview__detail">
                                    <p class="mb-0"><strong>{{ __('Order number') }}</strong></p>
                                    <p>#{{ $order->number }}</p>
                                </div>
                            </div>
                            <div class="col-12 col-md-6">
                                <div class="order-overview__detail">
                                    <p class="mb-0"><strong>{{ __('Order date') }}</strong></p>
                                    <p>{{ $order->created_at->format('d-m-Y H:i') }}</p>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12 col-md-6">
                                <div class="order-overview__detail">
                                    <p class="mb-0"><strong>{{ __('Payment method') }}</strong></p>
                                    <p>{{ $order->payment_method->label() }}</p>
                                </div>
                            </div>
                            <div class="col-12 col-md-6">
                                <div class="order-overview__detail">
                                    <p class="mb-0"><strong>{{ __('Shipping method') }}</strong></p>
                                    <p>{{ $order->shipping_method->label() }}</p>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12 col-md-6">
                                <div class="order-overview__detail">
                                    <p class="mb-0"><strong>{{ __('Billing address') }}</strong></p>
                                    <div class="order-overview__address">
                                        <address>
                                            <p>{{ $order->billingAddress->name }}</p>
                                            <p>{{ $order->billingAddress->address_line_1 }}</p>
                                            @if($order->billingAddress->address_line_2)
                                                <p>{{ $order->billingAddress->address_line_2 }}</p>
                                            @endif
                                            <p>{{ $order->billingAddress->postal_code }} {{ $order->billingAddress->city }}</p>
                                            <p>{{ $order->billingAddress->country->name }}</p>

                                            @if($order->billingAddress->vat_number)
                                                <div class="account__address-vat">
                                                    <p>{{ $order->billingAddress->vat_number }}</p>

                                                    @if($order->billingAddress->vat_number_verified_at && $order->billingAddress->country_id !== \App\Services\Countries::defaultCountry()->id)
                                                        <div class="account__address-vat--verified">
                                                            <img
                                                                src="{{ Vite::asset('resources/images/icons/icon-check.svg') }}"
                                                                alt="{{ __('VAT number verified') }}">
                                                            <p>{{ __('Eligible for VAT reverse charge.') }}</p>
                                                        </div>
                                                    @endif
                                                </div>
                                            @endif
                                        </address>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 col-md-6">
                                <div class="order-overview__detail">
                                    <p class="mb-0"><strong>{{ __('Shipping address') }}</strong></p>
                                    <div class="order-overview__address">
                                        <address>
                                            <p>{{ $order->shippingAddress->name }}</p>
                                            <p>{{ $order->shippingAddress->address_line_1 }}</p>
                                            @if($order->shippingAddress->address_line_2)
                                                <p>{{ $order->shippingAddress->address_line_2 }}</p>
                                            @endif
                                            <p>{{ $order->shippingAddress->postal_code }} {{ $order->shippingAddress->city }}</p>
                                            <p>{{ $order->shippingAddress->country->name }}</p>
                                        </address>
                                    </div>
                                </div>
                            </div>
                        </div>

                        @if($order->reference)
                            <div class="row">
                                <div class="col-12 col-md-6">
                                    <div class="order-overview__detail">
                                        <h4>{{ __('PO Number') }}</h4>
                                        <p>{{ $order->reference }}</p>
                                    </div>
                                </div>
                            </div>
                        @endif

                        @if($order->notes)
                            <div class="order-overview__detail">
                                <h4>{{ __('Notes') }}</h4>
                                <p>{{ $order->notes }}</p>
                            </div>
                        @endif

                        @if($status === \Daylight\Core\Models\Enums\OrderStatus::FAILED)
                            <div class="order-overview__actions">
                                <button wire:click.prevent="retryPayment" class="button button--primary">
                                    {{ __('Retry payment') }}
                                </button>

                                <button wire:click.prevent="cancel" class="button button--secondary">
                                    {{ __('Cancel order') }}
                                </button>
                            </div>
                        @elseif($status === \Daylight\Core\Models\Enums\OrderStatus::CANCELLED)
                            <div class="order-overview__actions">
                                <a href="{{ translatedRoute('page') }}" class="button button--primary">
                                    {{ __('Return to homepage') }}
                                </a>
                            </div>
                        @else
                            <div class="order-overview__actions">
                                <a href="{{ translatedRoute('account.orders.show', $order->uuid) }}" element="a" class="button button--primary">
                                    {{ __('View order in my account') }}
                                </a>

                                {{--                                <x-buttons.inline href="{{ translatedRoute('page') }}" element="a"--}}
                                {{--                                                  class="btn--full-width">--}}
                                {{--                                    {{ __('Back to homepage') }}--}}
                                {{--                                </x-buttons.inline>--}}
                            </div>
                        @endif
                    </x-panel>
                </div>

                <div class="col-12 col-lg-4">
                    <x-panel class="cart-summary">
                        <div class="cart-summary__header">
                            <h2>{{ __('Products') }} <span class="badge">{{ $order->items->count() }}</span></h2>
                        </div>

                        @foreach($order->items as $index => $item)
                            <div class="cart-item" wire:loading.delay.class="is-loading" wire:target="quantity, remove"
                                 wire:key="cart-drawer-item-{{ $item['id'] }}">
                                <div class="cart-item__left">
                                    <div class="cart-item__image">
                                        @if($item->variant->product)
                                            <a href="{{ translatedRoute('products.show', $item->variant->product->translations->first()->slug) }}">
                                                <img src="{{ $item->variant->getFirstMedia('gallery')->getUrl('thumbnail') }}" alt="{{ $item->variant->product->name }}">
                                            </a>
                                        @else
                                            <img src="{{ $item->variant->getFirstMedia('gallery')->getUrl('thumbnail') }}" alt="{{ $item->variant->product->name }}">
                                        @endif
                                    </div>

                                    <div class="cart-item__details justify-content-center">
                                        <div>
                                            <h4>{{ $item->quantity }}&times; {{ $item->variant->product->name }}</h4>
                                            <p>{{ $item->variant?->variantName }}</p>
                                            <p>{{ $item->sku }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="cart-item__right">
                                    <div class="cart-item__price">
                                        <p class="price">{{ formatPrice($item->quantity * $item->price) }}</p>
                                    </div>

                                    <div class="cart-item__delete">
                                        <button
                                            @click='dataLayer.push({event: "remove_from_cart", ecommerce: { items: [@json($item['dataLayer'])] }});'
                                            wire:click.prevent="deleteItem('{{ $item['id'] }}')">
                                            <svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor"
                                                 viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"
                                                 aria-hidden="true">
                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                      d="m14.74 9-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 0 1-2.244 2.077H8.084a2.25 2.25 0 0 1-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 0 0-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 0 1 3.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 0 0-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 0 0-7.5 0"></path>
                                            </svg>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        @endforeach

                        <dl class="cart-summary__summary">
                            <div>
                                <dt>{{ __('Subtotal') }}</dt>
                                <dd class="cart-summary__value">{{ formatPrice($order->subtotal) }}</dd>
                            </div>

                            @if($order->shipping)
                                <div>
                                    <dt>{{ __('Shipping') }}</dt>
                                    <dd class="cart-summary__value">{{ formatPrice($order->shipping) }}</dd>
                                </div>
                            @else
                                <div>
                                    <dt>{{ __('Pickup') }}</dt>
                                    <dd class="cart-summary__value">{{ __('Free') }}</dd>
                                </div>
                            @endif

                            @foreach($order->tax_breakdown as $key => $tax)
                                <div :key="{{ $key }}">
                                    <dt>{{ $tax['name'] }} ({{ floatval($tax['rate']) }}%)</dt>
                                    <dd class="cart-summary__value">{{ formatPrice($tax['amount'] / 100) }}</dd>
                                </div>
                            @endforeach

                            <div>
                                <dt>{{ __('Total') }}</dt>
                                <dd class="cart-summary__value">{{ formatPrice($order->total) }}</dd>
                            </div>
                        </dl>

                        <x-contact-cta :small="true" />
                    </x-panel>
                </div>
            </div>
        </div>
    </main>

    <script>
        dataLayer.push({ecommerce: null});
        dataLayer.push({event: 'purchase', ecommerce: {items: @json($dataLayerProducts) }});
    </script>
</div>
