<div class="variation-selector">
    @foreach ($this->options->sortBy('option.order') as $option)
        <div class="variation variation--{{ $option['option']->type ?? 'options' }}">
            <x-input.group
                label="{{ $option['option']->translations->filter(fn($t) => $t->locale === app()->getLocale())->first()->name }}"
                for="option-{{ $option['option']->id }}"
            >
                <div
                    class="variation__options"
                    x-data="{
                         selectedOption: @entangle('selectedOptionValues'),
                         selectedValues: [],
                    }"
                    x-init="
                        selectedValues = Object.values(selectedOption);
                        $watch('selectedOption', value => selectedValues = Object.values(selectedOption) )
                    ">
                    @if($option['option']->type === 'select')
                        <x-input.select id="option-{{ $option['option']->id }}" wire:change="$set('selectedOptionValues.{{ $option['option']->id }}', $event.target.value)">
                            <option value="" disabled>{{ __('Select an option') }}</option>

                            @foreach ($option['values'] as $value)
                                <option value="{{ $value->id }}">{{ $value->translations->filter(fn($t) => $t->locale === app()->getLocale())->first()->name }}</option>
                            @endforeach
                        </x-input.select>
                    @else
                        @foreach ($option['values']->sortBy('position') as $value)
                            <button type="button"
                                    wire:click="$set('selectedOptionValues.{{ $option['option']->id }}', {{ $value->id }})"
                                    style="
                                        --background-color: {{ $option['option']->type === 'swatches' ? $value->color : 'transparent' }};
                                    "
                                    :class="{
                                        'is-active': selectedValues.includes({{ $value->id }}),
                                    }">
                                {{ $option['option']->type !== 'swatches' ? $value->translations->filter(fn($t) => $t->locale === app()->getLocale())->first()->name : '' }}
                            </button>
                        @endforeach
                    @endif
                </div>
            </x-input.group>
        </div>
    @endforeach

    @isset($this->variant)
        <!-- Keep this for the variant selector -->
    @endif
</div>


