@section('head')
    <meta name="robots" content="{{ $page->page->robots }}">

    <link rel="canonical" href="{{ $localizedRoute->getCanonical()  }}"/>

    @foreach($localizedRoute->getHrefLangLinks() as $locale => $link)
        <link rel="alternate" hreflang="{{ $locale }}" href="{{ $link }}">
    @endforeach
@endsection

<x-layouts.app :title="$page->name" :localizedRoute="$localizedRoute">
    <main class="component-wrapper">
        @foreach($page->components as $block)
            @if($block->type !== 'template-content')
                <x-dynamic-component
                    :component="'blocks.' . $block->type"
                    :block="$block"
                    :lazyLoading="($loop->index >= 2)"
                />
            @else
                <x-partials.news
                    :paginatedArticles="$templateContent['news']"
                />
            @endif
        @endforeach
    </main>
</x-layouts.app>
