@section('head')
    <meta name="robots" content="{{ $product->product->robots }}">
    <link rel="canonical" href="{{ $localizedRoute->getCanonical()  }}"/>

    @foreach($localizedRoute->getHrefLangLinks() as $locale => $link)
        <link rel="alternate" hreflang="{{ $locale }}" href="{{ $link }}">
    @endforeach
@endsection

<x-layouts.app :title="$product->name" :localizedRoute="$localizedRoute">
    <x-breadcrumbs
        :pages="[
            __('Products') => translatedRoute('products.index'),
            $product->name => translatedRoute('products.show', $product->slug),
        ]"
    />

    <div class="product-single">
        <div class="container">
            <a class="product-single__back" href="{{ translatedRoute('products.index') }}">
                <svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24"
                     xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M10.5 19.5 3 12m0 0 7.5-7.5M3 12h18"></path>
                </svg>

                {{ __('Back to overview') }}
            </a>
        </div>

        <div class="product-single__main">
            <div class="container">
                <div class="product-single__inner">
                    <div class="row">
                        <div class="col-12 col-md-6">
                            @if($product->product->gallery->isNotEmpty())
                                <livewire:products.product-gallery
                                    :images="$product->product->gallery"
                                    :video-url="$product->product->variants->first()->video_url ?? null"
                                />
                            @else
                                <livewire:products.product-gallery
                                    :images="$product->product->variants->first()->getMedia()"
                                />
                            @endif
                        </div>

                        <div class="col-12 col-md-6 col-lg-5 ml-auto">
                            <livewire:products.article-number :variant="$product->product->variants->first()"/>

                            <h1 class="product-single__title">{{ $product->name }}</h1>


                            <div class="product-single__meta">
                                @auth
                                    <livewire:products.price :variant="$product->product->variants->first()"/>
                                @endif

                                <livewire:wishlist.add-to-wishlist
                                    :product="$product->product"
                                />
                            </div>

                            @guest
                                <div class="alert alert--info mb-4">
                                    <p>{{ __('Prices are only available after logging in. Sign in or create an account.') }}</p>
                                </div>
                            @endguest

                            @auth
                                @if($product->product->variants?->count() > 1)
                                    <livewire:products.variation-selector
                                        :product="$product"
                                        :key="$product->id"
                                    />
                                @endif
                            @endif

                            <livewire:products.add-to-cart
                                :disabled="auth()->guest()"
                                :variant="$product->product->variants->first()"
                                :product="$product"
                                :key="$product->id"
                            />

                            @if($product->product->variants?->count() === 1)
                                @if($product->product->variants->first()->inStock())
                                    <div class="product-single__stock">
                                        <svg data-slot="icon" fill="currentColor" viewBox="0 0 20 20"
                                             xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                            <path clip-rule="evenodd" fill-rule="evenodd"
                                                  d="M10 18a8 8 0 1 0 0-16 8 8 0 0 0 0 16Zm3.857-9.809a.75.75 0 0 0-1.214-.882l-3.483 4.79-1.88-1.88a.75.75 0 1 0-1.06 1.061l2.5 2.5a.75.75 0 0 0 1.137-.089l4-5.5Z"></path>
                                        </svg>

                                        {{ __('In stock') }}
                                    </div>
                                @else
                                    <div class="product-single__stock product-single__stock--out-of-stock">
                                        <svg data-slot="icon" fill="currentColor" viewBox="0 0 20 20"
                                             xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                            <path clip-rule="evenodd" fill-rule="evenodd"
                                                  d="M10 18a8 8 0 1 0 0-16 8 8 0 0 0 0 16ZM8.28 7.22a.75.75 0 0 0-1.06 1.06L8.94 10l-1.72 1.72a.75.75 0 1 0 1.06 1.06L10 11.06l1.72 1.72a.75.75 0 1 0 1.06-1.06L11.06 10l1.72-1.72a.75.75 0 0 0-1.06-1.06L10 8.94 8.28 7.22Z"></path>
                                        </svg>

                                        {{ __('Out of stock') }}
                                    </div>
                                @endif
                            @else
                                <livewire:products.stock-indicator
                                    :variant="$product->product->variants->first()"
                                />
                            @endif

                            <div class="product-single__score">
                                <div class="product-single__usps">
                                    <ul>
                                        <li>{{  __('Available within 3 working days') }}</li>
                                        <li>{{  __('Advice from professionals') }}</li>
                                        <li>{{ __('Free shipping') }}</li>
                                    </ul>
                                </div>

                                <div class="product-single__reviews">
                                    <div class="product-single__stars">
                                        <img src="{{ Vite::asset('resources/images/icons/icon-star.svg') }}"
                                             alt="{{ __('Star') }}">
                                        <img src="{{ Vite::asset('resources/images/icons/icon-star.svg') }}"
                                             alt="{{ __('Star') }}">
                                        <img src="{{ Vite::asset('resources/images/icons/icon-star.svg') }}"
                                             alt="{{ __('Star') }}">
                                        <img src="{{ Vite::asset('resources/images/icons/icon-star.svg') }}"
                                             alt="{{ __('Star') }}">
                                        <img src="{{ Vite::asset('resources/images/icons/icon-star.svg') }}"
                                             alt="{{ __('Star') }}">
                                    </div>

                                    {!! __('<strong>:score</strong> out of <a href=":url">:total reviews</a>', ['score' => 9.5, 'total' => 345, 'url' => '#']) !!}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="product-single__content">
        <div class="container">
            <div class="row">
                <div class="col-12 col-md-6">
                    <div class="product-single__description">
                        <h2>{{ __('Description') }}</h2>
                        {!! $product->description !!}
                    </div>
                </div>

                @if($product->product->downloads->isNotEmpty())
                    <div class="col-12 col-md-6">
                        <h2>{{ __('Downloads') }}</h2>

                        <div class="product-single__downloads">
                            @foreach($product->product->downloads as $download)
                                <a href="{{ $download->getUrl() }}" download class="product-single__download">
                                    <div class="product-single__download-left">
                                        <img src="{{ Vite::asset('resources/images/icons/icon-file.svg') }}" alt="">
                                        <div>
                                            <h4>{{ $download->name }}</h4>
                                            <p>{{ \Illuminate\Support\Number::fileSize($download->size) }}</p>
                                        </div>
                                    </div>
                                    <div class="product-single__download-right">
                                        <img src="{{ Vite::asset('resources/images/icons/icon-download.svg') }}" alt="">
                                    </div>
                                </a>
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>
        </div>

        @if($product->product->attributeValues->isNotEmpty())
            <div class="container">
            <div class="product-single__attributes">
                <h2>{{ __('Attributes') }}</h2>

                <div class="row">
                    @foreach($product->product->attributeValues->chunk(2) as $attributeGroup)
                        <div class="col-12 col-md-6">
                            <table>
                                @foreach($attributeGroup as $attributeValue)
                                    <tr>
                                        <td width="50%">{{ $attributeValue->attribute->name }}</td>
                                        <td>{{ $attributeValue->name }}</td>
                                    </tr>
                                @endforeach
                            </table>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
        @endif
    </div>

    {{--    <x-blocks.content-image/>--}}
    {{--    <x-blocks.testimonials/>--}}
    {{--    <x-blocks.products-slider/>--}}
    {{--    <x-blocks.cta/>--}}

    <script>
        dataLayer.push({ecommerce: null});

        dataLayer.push({
            event: 'view_item',
            ecommerce: {
                items: [@json($product->product->getDataLayerInformation())]
            },
        });

        @if($product->product->upSells->isNotEmpty())
        dataLayer.push({
            event: 'view_item_list',
            ecommerce: {
                item_list_id: 'related_products',
                item_list_name: 'Related Products',
                items: @json($product->product->upSells->map(fn($product) => $product->target->getDataLayerInformation())),
            },
        });
        @endif
    </script>
</x-layouts.app>
