<?php

namespace App\Components;

use Daylight\Core\Models\Enums\ProductStatus;
use Daylight\Core\Models\Product;
use Daylight\Core\Modules\PageBuilder\Entities\Component;
use Daylight\Core\Modules\PageBuilder\Entities\Field;
use Illuminate\Support\Collection;

class ProductSlider extends Component
{
    public string $type = 'product-slider';

    public function name(): string
    {
        return 'Product slider';
    }

    public function fields(): Collection
    {
        return collect([
            Field::text('title', __('Title'))->required(),
            Field::button('button', __('Button')),
            Field::related(
                name: 'products',
                label: __('Products'),
                type: Product::class,
                items: Product::whereStatus(ProductStatus::PUBLISHED->value)->get()
                    ->map(function (Product $product) {
                        return [
                            'id' => $product->id,
                            'label' => $product->name,
                        ];
                    })->toArray(),
            )->required(),
        ]);
    }
}
