<?php

namespace App\Daylight\Http\Requests\Settings;

use Daylight\Core\Modules\Multilingualism\Multilingualism;
use Illuminate\Foundation\Http\FormRequest;

class UpdateUspsRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->user()->can('update:settings');
    }

    public function rules(): array
    {
        $rules = Multilingualism::getAvailableLocales()
            ->mapWithKeys(fn ($locale) => [
                "usps.$locale" => ['required', 'array'],
                "usps.$locale.*" => ['string', 'max:255'],
            ])->toArray();

        return [
            'usps' => ['required', 'array'],
            ...$rules,
        ];
    }
}
