<?php

namespace App\Http\Controllers;

use Daylight\Core\Modules\Cart\Cart;
use Daylight\Core\Modules\Multilingualism\Entities\LocalizedRoute;

class CheckoutController extends Controller
{
    public function __invoke(Cart $cart)
    {
        if ($cart->count() === 0) {
            return redirect()->translatedRoute('cart.index');
        }

        $localizedRoute = LocalizedRoute::create()
            ->setRoute('checkout.index')
            ->staticRoute();

        return view('checkout.index', [
            'localizedRoute' => $localizedRoute,
        ]);
    }
}
