<?php

namespace App\Http\Controllers;

use Daylight\Core\Models\Order;
use Daylight\Core\Modules\Multilingualism\Entities\LocalizedRoute;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;

class CheckoutStatusController extends Controller
{
    public function __invoke(Request $request, ?string $orderUuid = null)
    {
        $localizedRoute = LocalizedRoute::create()
            ->setRoute('checkout.status', $orderUuid)
            ->staticRoute();

        $order = Order::query()
            ->where('uuid', $orderUuid)
            ->when(auth()->check(), function (Builder $builder) {
                $builder->where('user_id', auth()->id());
            })
            ->with([
                'billingAddress.country',
                'shippingAddress.country',
                'items.variant.product.translations',
            ])
            ->firstOrFail();

        return view('checkout.status', [
            'localizedRoute' => $localizedRoute,
            'order' => $order,
        ]);
    }
}
