<?php

namespace App\Livewire\Cart;

use Daylight\Core\Modules\Cart\Cart;
use Daylight\Core\Modules\Cart\Contracts\CartInterface;
use Illuminate\View\View;
use Livewire\Attributes\On;
use Livewire\Component;

class Button extends Component
{
    public function cart(): Cart
    {
        return app(CartInterface::class);
    }

    #[On('cart-updated')]
    public function render(): View
    {
        return view('livewire.cart.button');
    }

    public function placeholder(): View
    {
        return view('livewire.cart.button-placeholder');
    }
}
