<?php

namespace App\Livewire\Products;

use Daylight\Core\Models\Variant;
use Livewire\Attributes\On;
use Livewire\Component;

class StockIndicator extends Component
{
    public Variant $variant;

    #[On('current-variant-changed')]
    public function currentVariantChanged(Variant $variant)
    {
        $this->variant = $variant;
    }

    public function render()
    {
        return view('livewire.products.stock-indicator');
    }
}
