<?php

namespace App\Livewire\Search;

use Daylight\Core\Models\Product;
use Daylight\Core\Modules\Search\SearchQueryBuilder;
use Illuminate\View\View;
use Livewire\Attributes\On;
use Livewire\Component;

class SlideOver extends Component
{
    public bool $showSearchSlideOver = false;

    public string $searchQuery = '';

    #[On('show-search-slide-over')]
    public function showSearchSlideOver(): void
    {
        $this->showSearchSlideOver = true;
    }

    public function render(): View
    {
        $products = [];

        if (! empty($this->searchQuery)) {
            $query = SearchQueryBuilder::create()
                ->setBaseQuery(
                    Product::query()
                        ->with([
                            'translations' => fn ($q) => $q->where('locale', app()->getLocale()),
                            'variants.media',
                            'variants.prices',
                        ])
                )
                ->setActiveFilters([])
                ->setSearchQuery($this->searchQuery)
                ->get();

            $products = $query->getResults();
        }

        return view('livewire.search.slide-over', [
            'products' => $products,
        ]);
    }
}
